/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.dto.TimeTableRequestDto;
import com.baijia.tianxiao.dal.org.po.ClassHour;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author shanyu
 * @author shanyu
 * @version 1.0
 * @title OrgClassLessonDao
 * @desc TODO
 * @date 2015年12月8日
 */

public interface OrgClassLessonDao extends CommonDao<OrgClassLesson> {

    /**
     * 获取课次数量
     *
     * @param courseIds
     * @param date
     * @param orgId
     * @param delStatus
     * @return
     */
    public Map<Long, Integer> getLessonTimemap(Collection<Long> courseIds, Date date, Long orgId, Integer delStatus);

    /**
     * 根据课程id获取相对应的课节
     *
     * @param courseIds
     * @param date
     * @param orgId
     * @param delStatus
     * @param queryProps
     * @return
     */
    public List<OrgClassLesson> getLessons(Collection<Long> courseIds, Date date, Long orgId, Integer delStatus,
                                           String... queryProps);

    /**
     * 根据筛选时间获取课节信息
     *
     * @param courseIds 课程id
     * @param sartTime  筛选开始时间
     * @param endTime   筛选结束时间
     * @param pageDto   分页信息
     * @return
     */
    public List<OrgClassLesson> getLessons(Collection<Long> courseIds, Date startTime, Date endTime, PageDto pageDto);

    /*
     * 获取学生未上课节Ids
     */
    List<Long> getLeftLessonIds(Long orgId, Long courseId);

    List<Long> getOrgLessonIds(Long orgId);

    /**
     * 更新课节的教室信息
     *
     * @param orgId
     * @param lessonIds
     * @param roomId
     * @return
     */
    int updateLessonClassRoom(Long orgId, Collection<Long> lessonIds, Long roomId);

    /**
     * 获取一个学生的课程对应的已经安排的课节数目
     *
     * @param orgId
     * @param courseId
     * @param studentId
     * @return
     */
    Integer getLessonCountOfStudent(Long orgId, Long courseId, Long studentId);

    /**
     * @param orgId
     * @param courseIds
     * @param roomIds
     * @param startTime
     * @param endTime
     * @param page
     * @param queryProps
     * @return
     */
    List<OrgClassLesson> queryLessons(Long orgId, Collection<Long> courseIds, Collection<Long> roomIds,
                                      Collection<Long> lessonIds, Date startTime, Date endTime, PageDto page, String... queryProps);

    /**
     * 获取课程已完成课节数
     *
     * @param orgId
     * @param courseIds
     * @return
     */
    Map<Long, Integer> getFinishLessonCount(Long orgId, Collection<Long> courseIds, Integer delStatus);

    /**
     * 获取课程已安排课节数
     *
     * @param orgId
     * @param courseIds
     * @return
     */
    Map<Long, Integer> getLessonCount(Long orgId, Collection<Long> courseIds, Integer delStatus);

    /**
     * 获取课程已完成课节数
     *
     * @param orgId
     * @param courseIds
     * @return
     */
    Integer getFinishLessonCount(Long orgId, Long courseId, Integer delStatus);

    /**
     * 获取课程已安排课节数
     *
     * @param orgId
     * @param courseIds
     * @return
     */
    Integer getLessonCount(Long orgId, Long courseId, Integer delStatus);

    /**
     * @param lessonIdNumberMaps
     */
    void batchUpdateLessonNumber(Map<String, ?>[] lessonIdNumberMaps);

    public List<OrgClassLesson> getLessonByCourseIds(List<Long> courseIds);

    Map<Long, OrgClassLesson> getClassLessonMap(Long orgId, Collection<Long> lessonIds, Integer delStatus,
                                                String... props);

    Map<Long, OrgClassLesson> getClassLessonMap(Long orgId, Long courseId, Integer delStatus, String... props);

    /**
     * @param startTime
     * @param endTime
     * @param pageDto
     * @return
     */
    List<OrgClassLesson> querylessonsByEndTime(Date startTime, Date endTime, Integer delStatus, PageDto pageDto);

    /**
     * 获取课程课节数
     *
     * @param courseIds
     * @param studentId
     * @param teacherId
     * @return
     */
    Map<Long, Integer> getCourseLessonCount(Long orgId, Collection<Long> courseIds, Long studentId, Long teacherId,
                                            Date endTime);

    /**
     * 按照时间过滤Id
     *
     * @param lessonIds
     * @param date
     * @return
     */
    List<Long> filterLessonListByTime(Collection<Long> courseIds, Collection<Long> lessonIds, Date date);


    List<Long> finishLessonId(Collection<Long> lessonIds);

    /**
     * 按照课程和老师查询课节Id
     *
     * @param orgId
     * @param courseIds
     * @param teacherIds
     * @return
     */
    List<Long> filterLessonList(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds);

    /**
     * @param orgId
     * @param roomId
     * @param startTime
     * @return
     */
    List<OrgClassLesson> getLeftRoomIdLessons(Long orgId, Long roomId, Date startTime, String... queryProps);

    /**
     * 获取各个课程的应到数量
     *
     * @param orgId
     * @param courseIds
     * @return
     * @author shizuwei
     */
    Map<Long, Integer> getCourseAttendCountMap(Long orgId, Collection<Long> courseIds);

    /**
     * 获取各个学生的应到数量
     *
     * @param orgId
     * @param userIds
     * @return
     * @author shizuwei
     */
    Map<Long, Integer> getStudentAttendCountMap(Long orgId, Collection<Long> userIds);

    /**
     * 根据课程id，课节id获取课节信息
     *
     * @param orgId
     * @param courseIds
     * @param lessonIds
     * @return
     */
    Map<Long, List<OrgClassLesson>> getLessonMapByCourseAndLessonIds(Long orgId, Collection<Long> courseIds,
                                                                     Collection<Long> lessonIds);

    /**
     * 获取指定时间段内有签到的课节id
     *
     * @param orgId
     * @param startTime
     * @param endTime
     * @return
     */
    public List<Long> queryFinishedLessonIds(Long orgId, Long teacherId, Date startTime, Date endTime);

    /**
     * 获取老师课时列表(group by teacherId) 如果参数groupByCourse为true 则group by teacherId, courseId
     *
     * @param lessonIds
     * @param page
     * @param groupByCourse
     * @return
     */
    List<ClassHour> queryTeacherClassHourList(Collection<Long> lessonIds, Long teacherId, PageDto page,
                                              boolean groupByCourse);

    /**
     * 获取老师课时统计数据
     *
     * @param lessonIds
     * @param teacherId
     * @return
     */
    ClassHour queryTeacherClassHour(Collection<Long> lessonIds, Long teacherId);


    void refreshOrgClassLesson(Long orgId, Long id);

    /**
     * 获取所有机构课节总数
     *
     * @param startTime startTime和endTime不为null时查询某阶段
     * @param endTime
     */
    Map<Long, Integer> getLessonTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);

    /**
     * 获取所有机构安排课程总数
     *
     * @param startTime startTime和endTime不为null时查询某阶段
     * @param endTime
     */
    Map<Long, Integer> getArrangedClassCount(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);

    /**
     * 根据课程ids获取其已上完课节或者未开课课程ids
     */
    public List<Long> getOrgCourseIdList(Date startTime, Date endTime, Collection<Long> courseIds);
    
    /**
     * 根据机构orgIds获取机构所有排课信息
     * @param orgIds
     * @param nowDate 不为null时表示当前正在进行上课的排课信息
     * @return
     */
    List<OrgClassLesson> getOrgClassLessonsByOrgIds(Collection<Long> orgIds, Date nowDate);

    /**
     * 
     */
    public List<OrgClassLesson> getOrgClassLessonList(Collection<Long> courseIds);

    List<ClassHour> queryFinishedLessonCountByTeacherIds(Long orgId, Collection<Long> teacherIds, Date startTime, Date endTime);

    public Integer getLessonCount(Integer orgId, List<Long> courseIds, Date endTime);

    List<OrgClassLesson> querylessonsByStartTime(Date startTime, Long courseId, Long orgId);
    
    List<OrgClassLesson> queryEndedlessons(Long courseId, Long orgId);

    /**
     * @param orgId
     * @param courseIds
     * @param roomIds
     * @param lessonIds
     * @param startTime
     * @param endTime
     * @param page
     * @param queryProps
     * @return
     */
        
    List<OrgClassLesson> querySignInLessons(Long orgId, Collection<Long> courseIds, Collection<Long> roomIds,
        Collection<Long> lessonIds, Date startTime, Date endTime, PageDto page,Long lessonId, String... queryProps);

    public List<OrgClassLesson> getOrgClassLessonsByStartTime(Date startTime, Date endTime,PageDto pageDto);

    List<OrgClassLesson> getOrgClassLessons(Long orgId,Long courseId,Long studentId);

    public List<OrgClassLesson> getOrgClassLessonsByUpdateTime(Date startTime, Date endTime,PageDto pageDto);
    

    /**
     * 根据条件查询课表信息
     * @param orgId
     * @param params
     * @param includeIds
     * @return
     */
    public List<OrgClassLesson> getOrgClassLessonByParams(Long orgId, TimeTableRequestDto params, Collection<Long> includeIds, PageDto pageDto);

    /**
     * 根据条件筛选课节
     * @param orgId：机构id
     * @param teacherLessonIds：课节id集合
     * @param confictLessonIds：课节id集合
     * @param courseIds：课程id集合
     * @return
     */
	public List<OrgClassLesson> queryByParams(Long orgId, List<Long> teacherLessonIds, List<Long> confictLessonIds, List<Long> courseIds);

	/**
	 * 根据教室id集合获得课节列表
	 * @param orgId：机构id
	 * @param classRoomIds：教室id集合
	 * @param courseIds：课程id集合
	 * @param confictLessonIds：有冲突的课节id列表
	 * @return
	 */
	public List<OrgClassLesson> queryByClassRooms(Long orgId, List<Long> classRoomIds, List<Long> courseIds, List<Long> confictLessonIds);

	/**
	 * 根据给定筛选条件筛选课节
	 * @param orgId：机构id
	 * @param teacherIds：课节老师id集合
	 * @param classRoomIds：课节教室id集合
	 * @param confictLessonIds：有冲突的课节id集合
	 * @return
	 */
	public List<OrgClassLesson> queryForSelectCourse(Long orgId, List<Long> classRoomIds, List<Long> confictLessonIds, List<Long> teacherLessonIds);

    public OrgClassLesson getByIdForUpdate(Long id);

    /**
     * 根据课程ID批量删除课节
     * @param orgId
     * @param courseIds
     */
    public void deleteByCourseIds(Long orgId, Collection<Long> courseIds);

    /**
     * 初始化數據使用
     * @return
     */
    List<OrgLessonConflict> getflushConflictData();
    
    /**
     * 批量逻辑删除课节
     * 
     * @param orgId
     * @param lessonIds
     */
        
    public void updateDelByLessonIds(Long orgId, Collection<Long> lessonIds);
}
