/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgStudentCourseDaoImpl
extends JdbcTemplateDaoSupport<OrgStudentCourse>
implements OrgStudentCourseDao {
    public OrgStudentCourseDaoImpl() {
        super(OrgStudentCourse.class);
    }

    @Override
    public List<Long> getStudents(Long orgId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public OrgStudentCourse getStudentCourse(@NonNull Long orgId, @NonNull Long courseId, @NonNull Long userId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        return (OrgStudentCourse)this.uniqueResult(builder);
    }

    @Override
    public List<OrgStudentCourse> getStudentListByCourseId(Long orgId, Long courseId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.add(Expressions.or((Expression)Expressions.eq((String)"orgId", (Serializable)orgId), (Expression)Expressions.eq((String)"orgId", (Serializable)Integer.valueOf(0))));
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.select(queryProps);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public void deleteOrgCourseStudent(Long orgId, Long courseId, Long userId, Integer status) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", courseId);
        condition.put("userId", userId);
        OrgStudentCourse obj = new OrgStudentCourse();
        obj.setStatus(status);
        this.update(condition, obj, new String[]{"status"});
    }

    @Override
    public List<OrgStudentCourse> getStudentListByStudentId(Long userId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        builder.select(queryProps);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<OrgStudentCourse>> getStudentMapBycourseIds(Collection<Long> courseIds, final String ... queryProps) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.select(queryProps);
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgStudentCourse orgStudentCourse : courses) {
            List orgStudentCourses = (List)map.get(orgStudentCourse.getCourseId());
            if (orgStudentCourses == null) {
                orgStudentCourses = Lists.newArrayList();
                map.put(orgStudentCourse.getCourseId(), orgStudentCourses);
            }
            orgStudentCourses.add(orgStudentCourse);
        }
        return map;
    }

    @Override
    public Map<Long, List<Long>> getStudentIdMapBycourseIds(Collection<Long> courseIds, final Long orgId) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.eq("status", (Serializable)Integer.valueOf(0));
                builder.eq("orgId", (Serializable)orgId);
                builder.select(new String[]{"courseId", "userId"});
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)courses, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getCourseId();
            }
        }, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public Map<Long, Integer> getCurStudentCntByCourseIds(final Long orgId, Collection<Long> courseIds, String ... queryProps) {
        MapBatchQueryTemplate batchTemplate = new MapBatchQueryTemplate();
        return (Map)batchTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.count("id");
                builder.add(Expressions.or((Expression)Expressions.eq((String)"orgId", (Serializable)orgId), (Expression)Expressions.eq((String)"orgId", (Serializable)Integer.valueOf(0))));
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.group("courseId");
                builder.in("courseId", querySet);
                List queryList = OrgStudentCourseDaoImpl.this.query2ListMap(builder);
                if (CollectionUtils.isNotEmpty((Collection)queryList)) {
                    HashMap result = Maps.newHashMap();
                    for (Map objMap : queryList) {
                        result.put(((Number)objMap.get("courseId")).longValue(), ((Number)objMap.get("cnt_id")).intValue());
                    }
                    return result;
                }
                return Collections.emptyMap();
            }
        });
    }

    @Override
    public void updateStudentName(Long userId, String studentName) {
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        params.put("studentName", studentName);
        this.getNamedJdbcTemplate().update("update tts.org_student_course set student_name = :studentName where student_id = :userId", (Map)params);
    }

    @Override
    public List<Long> getOrgCourseIds(Long orgId, List<Long> courseIds, boolean ascByStuCnt, PageDto pageDto) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.count("id", "cnt");
        builder.in("courseId", courseIds);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.eq("tradeComplete", (Serializable)Integer.valueOf(1));
        builder.group("courseId");
        if (ascByStuCnt) {
            builder.asc("cnt");
        } else {
            builder.desc("cnt");
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getStudents(Long orgId, Long courseId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)status);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, Integer> getStudentCount(Long orgId, Collection<Long> courseIds) {
        return this.getStudentCount(orgId, courseIds, null);
    }

    @Override
    public Map<Long, Integer> getStudentCount(final Long orgId, Collection<Long> courseIds, final Boolean tradeComplete) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.eq("status", (Serializable)Integer.valueOf(0));
                if (tradeComplete != null) {
                    builder.eq("tradeComplete", (Serializable)Integer.valueOf(tradeComplete != false ? 1 : 0));
                }
                builder.group("courseId");
                final HashMap result = Maps.newHashMap();
                OrgStudentCourseDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<OrgStudentCourse> getOrgCourseIds(Long orgId, Long userId, Integer status, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.asc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getOrgCourseIds(Long orgId, Long userId, PageDto pageDto) {
        return this.getOrgCourseIds(orgId, userId, null, pageDto);
    }

    @Override
    public List<OrgStudentCourse> getOrgCourseByOrgId(Long orgId, Collection<Long> courseIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (courseIds != null && !courseIds.isEmpty()) {
            builder.in("courseId", courseIds);
        }
        builder.group("courseId");
        builder.desc("createTime");
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer getStudentCourseCount(Long orgId, Long userId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getStudentSignupCourseCount(Long orgId, Long userId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.distinctCount("courseId");
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Long> getStudentCourseIds(Long orgId, Long userId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getStudentCourseIdsByStatus(Long orgId, Long userId, List<Integer> status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.in("status", status);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getStudentIdsByCourseIds(final Long orgId, Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.eq("orgId", (Serializable)orgId);
                builder.in("courseId", querySet);
                return OrgStudentCourseDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public void refreshOrgStudentCourse(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update tts.org_student_course set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }
}

