/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.utils;

import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SolrUtil {
    private static String LIKE_FORMAT = "%s %s:*%s*";

    public static String exclude(String field) {
        if (StringUtils.isBlank((String)field)) {
            throw new RuntimeException("Unexcept param:" + field);
        }
        return String.format("-%s:*", field);
    }

    public static String equal(String field, Object obj) {
        if (StringUtils.isBlank((String)field) || obj == null) {
            throw new RuntimeException("Unexcept param:" + field + ", value:" + obj);
        }
        return String.format("%s:%s", field, obj.toString().replaceAll("\\-", "\\\\-"));
    }

    public static String notEqual(String field, Object obj) {
        if (StringUtils.isBlank((String)field) || obj == null) {
            throw new RuntimeException("Unexcept param:" + field + ", value:" + obj);
        }
        return String.format("-%s:%s", field, obj.toString().replaceAll("\\-", "\\\\-"));
    }

    public static String include(String field) {
        if (StringUtils.isBlank((String)field)) {
            throw new RuntimeException("Unexcept param:" + field);
        }
        return String.format("+%s:*", field);
    }

    public static String range(String field, RangeType type, Object bottom, Object top) {
        if (StringUtils.isBlank((String)field) || bottom == null || top == null || type == null) {
            throw new RuntimeException("Unexcept param:" + field + ", bottom:" + bottom + ", top:" + top);
        }
        return String.format("%s:%c %s TO %s %c", field, Character.valueOf(type.getLeft()), bottom.toString().replaceAll("\\-", "\\\\-"), top.toString().replaceAll("\\-", "\\\\-"), Character.valueOf(type.getRight()));
    }

    public static String notRange(String field, RangeType type, Object bottom, Object top) {
        if (StringUtils.isBlank((String)field) || bottom == null || top == null || type == null) {
            throw new RuntimeException("Unexcept param:" + field + ", bottom:" + bottom + ", top:" + top);
        }
        return String.format("-%s:%c %s TO %s %c", field, Character.valueOf(type.getLeft()), bottom.toString().replaceAll("\\-", "\\\\-"), top.toString().replaceAll("\\-", "\\\\-"), Character.valueOf(type.getRight()));
    }

    public static String any(String field) {
        if (StringUtils.isBlank((String)field)) {
            throw new RuntimeException("Unexcept param:" + field);
        }
        return String.format("%s:*", field);
    }

    public static String or(String field, Collection<?> vals) {
        if (StringUtils.isBlank((String)field) || vals == null || vals.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder(field).append(":( ");
        for (Object val : vals) {
            sb.append(val.toString().replaceAll("\\-", "\\\\-")).append(" OR ");
        }
        sb.delete(sb.length() - 3, sb.length());
        sb.append(")");
        return sb.toString();
    }

    public static String or(List<List<QueryItem>> queryItemGroup) {
        if (CollectionUtils.isEmpty(queryItemGroup)) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (List<QueryItem> queryItems : queryItemGroup) {
            if (CollectionUtils.isEmpty(queryItems)) {
                throw new RuntimeException("Unexcept params");
            }
            sb.append("(");
            for (QueryItem item : queryItems) {
                if (item.equal.booleanValue()) {
                    sb.append(String.format("%s:%s", item.field, item.val.toString().replaceAll("\\-", "\\\\-")));
                } else {
                    sb.append(String.format("-%s:%s", item.field, item.val.toString().replaceAll("\\-", "\\\\-")));
                }
                sb.append(" AND ");
            }
            sb.delete(sb.length() - 4, sb.length());
            sb.append(")");
            sb.append(" OR ");
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    public static String notOr(Map<String, ?> valByField) {
        if (valByField == null || valByField.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : valByField.keySet()) {
            sb.append(String.format("-%s:%s OR ", field, valByField.get(field)));
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    public static String or(Map<String, ?> valByField) {
        if (valByField == null || valByField.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : valByField.keySet()) {
            sb.append(String.format("%s:%s OR ", field, valByField.get(field)));
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    public static String notAnd(Map<String, ?> valByField) {
        return "-(" + SolrUtil.and(valByField) + ")";
    }

    public static String and(Map<String, ?> valByField) {
        if (valByField == null || valByField.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : valByField.keySet()) {
            sb.append(String.format("%s:%s AND ", field, valByField.get(field)));
        }
        sb.delete(sb.length() - 4, sb.length());
        return sb.toString();
    }

    public static void main(String[] args) {
        ArrayList<QueryItem> items = new ArrayList<QueryItem>();
        items.add(new QueryItem("a", 9));
        items.add(new QueryItem("b", 19));
        items.add(new QueryItem("c", 29, false));
        ArrayList<List<QueryItem>> result = new ArrayList<List<QueryItem>>();
        result.add(items);
        items = new ArrayList();
        items.add(new QueryItem("aa", 229, false));
        items.add(new QueryItem("bb", 129));
        items.add(new QueryItem("cc", 2911, false));
        result.add(items);
        System.out.println(SolrUtil.or(result));
        HashMap<String, Integer> valMap = new HashMap<String, Integer>();
        valMap.put("m0", 0);
        valMap.put("m1", 0);
        valMap.put("m2", 0);
        valMap.put("m3", 0);
        System.out.println(SolrUtil.and(valMap));
        System.out.println(SolrUtil.notAnd(valMap));
    }

    public static String like(String field, String searchKey, Boolean ... isNeedContect) {
        String left = "";
        if (GenericsUtils.notNullAndEmpty((Object)isNeedContect)) {
            boolean isNeedContect_ = isNeedContect[0];
            left = isNeedContect_ ? " AND " : " OR ";
        }
        return String.format(LIKE_FORMAT, left, field, searchKey);
    }

    public static enum RangeType {
        INCLUDE_BOTTOM_EXCLUDE_TOP('[', '}'),
        INCLUDE_BOTTOM_INCLUDE_TOP('[', ']'),
        EXCLUDE_BOTTOM_EXCLUDE_TOP('{', '}'),
        EXCLUDE_BOTTOM_INCLUDE_TOP('{', ']');

        private char leftBracket;
        private char rightBracket;

        private RangeType(char left, char right) {
            this.leftBracket = left;
            this.rightBracket = right;
        }

        public char getLeft() {
            return this.leftBracket;
        }

        public char getRight() {
            return this.rightBracket;
        }
    }

    public static class QueryItem {
        String field;
        Object val;
        Boolean equal;

        public QueryItem(String field, Object val, boolean equal) {
            this.field = field;
            this.val = val;
            this.equal = equal;
        }

        public QueryItem(String field, Object val) {
            this.field = field;
            this.val = val;
            this.equal = true;
        }
    }
}

