/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.solr.enums.OrgTeacherUseStatus;
import com.baijia.tianxiao.dal.solr.query.OrgTeacherQuery;
import com.baijia.tianxiao.dal.solr.query.impl.SolrAbstractServiceImpl;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherQueryImpl
extends SolrAbstractServiceImpl
implements OrgTeacherQuery {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherQueryImpl.class);

    @Override
    public List<OrgTeacherDocument> queryOrgTeachers(Integer lastId, Integer orgId, Integer useStatus, Integer countType, Integer orderType, String searchKey, PageDto pageDto) {
        if (pageDto == null) {
            pageDto = new PageDto();
            pageDto.setPageNum(Integer.valueOf(1));
            pageDto.setPageSize(Integer.valueOf(100));
        }
        log.info("solr with params -- orgID:{}", (Object)orgId);
        StringBuilder queryBuilder = new StringBuilder();
        SolrQuery query = new SolrQuery();
        String currentDate = DateUtil.getCurrentYM();
        queryBuilder.append("id:t_* AND  orgId:").append(orgId).append(" AND ").append(SolrUtil.equal("dataMonth", currentDate));
        if (useStatus != null) {
            queryBuilder.append(" AND ").append(SolrUtil.equal("useStatus", useStatus));
        } else {
            queryBuilder.append(" AND ").append(SolrUtil.or("useStatus", OrgTeacherUseStatus.normalStatus));
        }
        TwoTuple<String, Integer> sortRule = this.getSolrRule(countType, orderType);
        if (GenericsUtils.notNullAndEmpty((Object)searchKey)) {
            queryBuilder.append(" AND (").append(SolrUtil.like("mobile", searchKey, new Boolean[0])).append(SolrUtil.like("name", searchKey, Boolean.FALSE)).append(")");
        }
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int limit = pageDto.getPageSize();
        query.setQuery(queryBuilder.toString());
        query.setStart(Integer.valueOf(start));
        query.setRows(Integer.valueOf(limit));
        query.addSort((String)sortRule.first, (Integer)sortRule.second == 0 ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        List<OrgTeacherDocument> retList = this.searchDocumentFromSolr(query, pageDto);
        return retList;
    }

    private OrgTeacherDocument builderDocument(SolrDocument solrDocument) {
        Map fieldValueMap = solrDocument.getFieldValueMap();
        log.info("======is:{} ", (Object)123);
        Map newFieldValueMap = GenericsUtils.copyMap((Map)fieldValueMap);
        log.info("fieldValueMap is :{} ", (Object)newFieldValueMap);
        OrgTeacherDocument solrDocumentRet = new OrgTeacherDocument();
        try {
            BeanUtils.populate((Object)solrDocumentRet, (Map)newFieldValueMap);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("error is:{} ", (Throwable)e);
        }
        return solrDocumentRet;
    }

    public TwoTuple<String, Integer> getSolrRule(Integer countType, Integer orderType) {
        String field = "createTime";
        Integer order = 0;
        switch (countType) {
            case 0: {
                field = "createTime";
                break;
            }
            case 1: {
                field = "finishedClassTime";
                break;
            }
            case 2: {
                field = "hasSignupStudentCount";
                break;
            }
            case 3: {
                field = "scoreNum";
                break;
            }
            case 4: {
                field = "pauseTime";
                break;
            }
            default: {
                field = "createTime";
            }
        }
        if (orderType != null && orderType == 2) {
            order = 1;
        }
        return TupleUtil.tuple((Object)field, (Object)order);
    }

    @Override
    public List<OrgTeacherDocument> queryOrgTeachersWithIds(Integer orgId, Collection<Long> teacherIds, Boolean ... isIdQuery) {
        if (GenericsUtils.isNullOrEmpty(teacherIds)) {
            return GenericsUtils.emptyList();
        }
        boolean isId = GenericsUtils.notNullAndEmpty((Object)isIdQuery) ? isIdQuery[0] : true;
        String queryField = isId ? "orgTeacherId" : "teacherUserId";
        log.info("solr with params -- orgID:{}");
        StringBuilder queryBuilder = new StringBuilder();
        SolrQuery query = new SolrQuery();
        queryBuilder.append("id:t_* AND  orgId:").append(orgId).append(" AND ").append(SolrUtil.or(queryField, teacherIds));
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        query.setQuery(queryBuilder.toString());
        List<OrgTeacherDocument> retList = this.searchDocumentFromSolr(query, new PageDto[0]);
        return retList;
    }

    private List<OrgTeacherDocument> searchDocumentFromSolr(SolrQuery query, PageDto ... pageDtos) {
        PageDto pageDto = GenericsUtils.isNullOrEmpty((Object)pageDtos) ? null : pageDtos[0];
        log.info("[OrgTeacherQueryImpl] query from solr :{} ", (Object)query.getQuery());
        QueryResponse response = null;
        try {
            response = this.getSolr().query("erp_classroom", (SolrParams)query, SolrRequest.METHOD.POST);
        }
        catch (IOException | SolrServerException e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"[OrgTeacherQueryImpl] can not find orgTeacherDocument with query :{} ", (Object[])new Object[]{query.getQuery()});
            throw new RuntimeException("solr service error !");
        }
        ArrayList retList = Lists.newArrayList();
        SolrDocumentList documentList = response.getResults();
        Iterator iterator = documentList.iterator();
        while (iterator.hasNext()) {
            OrgTeacherDocument solrDocument = this.builderDocument((SolrDocument)iterator.next());
            retList.add(solrDocument);
        }
        if (pageDto != null) {
            long total = documentList.getNumFound();
            pageDto.setCount(Integer.valueOf((int)total));
            log.info("find totalCount is :{} and PageDto is:{} ", (Object)total, (Object)pageDto);
        }
        return retList;
    }
}

