/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.tianxiao.dal.solr.constant.ConsultConstant;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.PCConsultOrderEnum;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.dal.solr.query.ConsultUserQuery;
import com.baijia.tianxiao.dal.solr.query.impl.SolrAbstractServiceImpl;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultUserQueryImpl
extends SolrAbstractServiceImpl
implements ConsultUserQuery {
    private static final Logger log = LoggerFactory.getLogger(ConsultUserQueryImpl.class);
    private static final Long ONE_DAY_TIME = 86400000L;
    private static final String keys = "id,org_id,is_consulter,finally_hold_time,last_pull_time,last_push_time,last_invalid_time,last_browse_time,last_remind_time,user_id,user_number,sex,student_name,student_id,name,nick_name,consult_source,mobile,weixin,weixin_nick_name,weixin_app_id,weixin_open_id,parent_name,parent_mobile,portrait,intension_level,consult_status,del_status,next_remind_Time,school,qq,mail,birthday,degree_class,address,create_time,relatives,update_time,manually,area_id,longitude,latitude,pinyin,is_invalid,campus_org_id,cascade_id,custom_search_value";
    private static final String QUERY_NO_THING = "NEED NOT QUERY ANYTHING";

    @Override
    public List<ConsulterListDto> queryConsulter(Collection<Integer> cascadeIds, ConsulterListQueryParam param, PageDto pageDto) {
        log.info("consulterListQueryParam is : {} ", (Object)param);
        String querySql = this.getconsultUserIds(cascadeIds, param);
        if (querySql.equals(QUERY_NO_THING)) {
            log.info("query for tag and find nothing , will ret empty list with queryParams:{},cascadeIds are:{}", (Object)param, cascadeIds);
            return GenericsUtils.emptyList();
        }
        log.info("[solr query is : {} ] ", (Object)querySql);
        ArrayList<ConsulterListDto> retList = new ArrayList<ConsulterListDto>();
        SolrQuery query = new SolrQuery();
        query.setQuery(querySql);
        int start = 0;
        int limit = Integer.MAX_VALUE;
        if (pageDto != null) {
            start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            limit = pageDto.getPageSize();
        }
        query.setStart(Integer.valueOf(start));
        query.setRows(Integer.valueOf(limit));
        TwoTuple<String, Integer> sortRule = param.getSortRule();
        log.info("sortRule is -- orderName: {} and sortType:{} ", sortRule.first, sortRule.second);
        query.addSort((String)sortRule.first, (Integer)sortRule.second == 0 ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        QueryResponse response = null;
        try {
            log.info("Solr QueryParam=" + query.toString() + "=========Start=" + start + ";limit=" + limit);
            response = this.getSolr().query("crm_consultor", (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList documentList = response.getResults();
            Iterator iterator = documentList.iterator();
            while (iterator.hasNext()) {
                retList.add(this.buildConsulterListDto((SolrDocument)iterator.next(), param.getConsulterType()));
            }
            long total = documentList.getNumFound();
            if (pageDto == null) {
                pageDto = new PageDto();
            }
            pageDto.setCount(Integer.valueOf((int)total));
            log.info("[Solr] Query count=" + total);
        }
        catch (SolrServerException e) {
            log.error("[Solr] query consult user SolrServerException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("[Solr] query consult user IOException", (Throwable)e);
        }
        return retList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getconsultUserIds(Collection<Integer> cascadeIds, ConsulterListQueryParam param) {
        Integer notFollowDayNum;
        Integer recentBrowseDayNum;
        Integer backDayNum;
        String dateFieldKey;
        String keyFieldName;
        TimeRange timeRange;
        TimeType tr;
        TimeRange timeRange2;
        Integer setInvalidDayNum;
        Integer createDayNum;
        String keyWrod;
        StringBuilder sb = new StringBuilder();
        sb.append("id:c_*  AND del_status:0").append(" AND is_consulter:").append(param.getIsConsulter());
        sb.append(this.createEquals("org_id", param.getOrgId()));
        if (param.getConsulterType() != ConsultConstant.INVALID && GenericsUtils.notNullAndEmpty(cascadeIds)) {
            sb.append(" AND ").append(SolrUtil.or("cascade_id", cascadeIds));
        }
        if (param.getIsInvalid() != null) {
            sb.append(this.createEquals("is_invalid", param.getIsInvalid()));
        }
        if (param.getSex() != null) {
            sb.append(this.createEquals("sex", param.getSex()));
        }
        if (CollectionUtils.isNotEmpty(param.listConsultSource())) {
            int size = param.listConsultSource().size();
            if (size == 1) {
                sb.append(this.createEquals("consult_source", param.listConsultSource().get(0)));
            } else {
                sb.append(this.createIn("consult_source", param.listConsultSource()));
            }
        }
        if (param.getIntentLevel() != null && param.getIntentLevel() != 0) {
            sb.append(this.createEquals("intension_level", param.getIntentLevel()));
        }
        if (param.getConsultStatus() != null) {
            sb.append(this.createEquals("consult_status", param.getConsultStatus()));
        }
        if (GenericsUtils.notNullAndEmpty((Object)(keyWrod = param.getKeyword()))) {
            keyWrod = ClientUtils.escapeQueryChars((String)keyWrod);
            String keyFieldName2 = PCConsultOrderEnum.getMatchFieldWithDefault(param.getKeyFieldName(), null, true);
            if (keyFieldName2 != null) {
                log.info("keyFieldName is : {} and queryValue is : {} ", (Object)keyFieldName2, (Object)keyWrod);
                if (!keyFieldName2.equals(PCConsultOrderEnum.TAG.matchField)) {
                    if (keyFieldName2.equals("custom_search_value")) {
                        sb.append(" AND custom_search_value:").append(StringEscapeUtils.unescapeJava((String)param.getKeyword()));
                    } else {
                        sb.append(this.createEquals(keyFieldName2, "*" + keyWrod + "*"));
                    }
                } else {
                    Set<Long> queryConsultIdByTags = this.queryConsultIdByTags(keyWrod, param.getOrgId());
                    if (!GenericsUtils.notNullAndEmpty(queryConsultIdByTags)) return QUERY_NO_THING;
                    if (queryConsultIdByTags.size() >= 1000) {
                        HashSet<Long> subSets = new HashSet<Long>(1000);
                        Iterator<Long> iterator = queryConsultIdByTags.iterator();
                        int index = 0;
                        while (iterator.hasNext()) {
                            subSets.add(iterator.next());
                            if (++index <= 1000) continue;
                        }
                        queryConsultIdByTags = subSets;
                    }
                    String or = SolrUtil.or("c_self_id", queryConsultIdByTags);
                    sb.append(" AND ").append(or);
                }
            } else {
                HashMap<String, String> valByField = new HashMap<String, String>();
                valByField.put("name", "*" + keyWrod + "*");
                valByField.put("pinyin", "*" + keyWrod + "*");
                if (keyWrod.length() > 3) {
                    try {
                        new BigDecimal(keyWrod);
                        valByField.put("mobile", "*" + keyWrod + "*");
                    }
                    catch (Exception or) {
                        // empty catch block
                    }
                }
                sb.append(" AND ( ").append(SolrUtil.or(valByField));
                Set<Long> queryConsultIdByTags = this.queryConsultIdByTags(keyWrod, param.getOrgId());
                if (GenericsUtils.notNullAndEmpty(queryConsultIdByTags) && GenericsUtils.notNullAndEmpty(queryConsultIdByTags)) {
                    if (queryConsultIdByTags.size() >= 1000) {
                        HashSet<Long> subSets = new HashSet<Long>(1000);
                        Iterator<Long> iterator = queryConsultIdByTags.iterator();
                        int index = 0;
                        while (iterator.hasNext()) {
                            subSets.add(iterator.next());
                            if (++index <= 1000) continue;
                        }
                        queryConsultIdByTags = subSets;
                    }
                    String or = SolrUtil.or("c_self_id", queryConsultIdByTags);
                    sb.append(" OR ").append(or);
                }
                sb.append(")");
            }
        }
        sb.append(this.createEquals("student_id", ConsultConstant.CONSULT_STUDENT_ID_DEFAULT_VALUE));
        Integer remindDayNum = param.getRemindDayNum();
        Date now = new Date();
        if (remindDayNum != null) {
            TimeRange timeRange3 = new TimeRange();
            timeRange3.setStartTime(DateUtil.getStartOfDay((Date)now));
            timeRange3.setEndTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() + (long)remindDayNum.intValue() * ONE_DAY_TIME)));
            sb.append(this.createTimeRangeSql("next_remind_time", timeRange3, true));
        }
        if ((createDayNum = param.getCreateDayNum()) != null) {
            TimeRange timeRange4 = new TimeRange();
            timeRange4.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(createDayNum - 1) * ONE_DAY_TIME)));
            timeRange4.setEndTime(now);
            sb.append(this.createTimeRangeSql("create_time", timeRange4, new boolean[0]));
        }
        if ((setInvalidDayNum = param.getInvalidDayNum()) != null) {
            TimeRange timeRange5 = new TimeRange();
            timeRange5.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(setInvalidDayNum - 1) * ONE_DAY_TIME)));
            timeRange5.setEndTime(now);
            sb.append(this.createTimeRangeSql("last_invalid_time", timeRange5, new boolean[0]));
        }
        Integer minRemainingDay = param.getMinRemainingDay();
        Integer maxRemainingDay = param.getMaxRemainingDay();
        if (minRemainingDay != null && maxRemainingDay != null) {
            if (minRemainingDay <= 1) {
                minRemainingDay = 0;
            }
            if (maxRemainingDay <= 1) {
                maxRemainingDay = 1;
            }
            if (minRemainingDay > maxRemainingDay) {
                Integer temp = minRemainingDay;
                minRemainingDay = maxRemainingDay;
                maxRemainingDay = temp;
            }
            Long minDayDept = now.getTime() + (long)minRemainingDay.intValue() * ONE_DAY_TIME;
            Long maxDayDept = now.getTime() + (long)(maxRemainingDay + 1) * ONE_DAY_TIME;
            timeRange2 = new TimeRange();
            timeRange2.setStartTime(DateUtil.getStartOfDay((Date)new Date(minDayDept)));
            timeRange2.setEndTime(DateUtil.getStartOfDay((Date)new Date(maxDayDept)));
            sb.append(this.createTimeRangeSql("finally_hold_time", timeRange2, new boolean[0]));
        }
        if (param.getLastRemindTimeState() != null && (tr = TimeType.getTimeTypeByCode(param.getLastRemindTimeState())) != null) {
            timeRange = tr.timeRange();
            sb.append(this.createTimeRangeSql("last_remind_time", timeRange, true));
        }
        if (param.getDateFieldKey() != null && (keyFieldName = PCConsultOrderEnum.getMatchFieldWithDefault(dateFieldKey = ClientUtils.escapeQueryChars((String)param.getDateFieldKey()), null, true)) != null) {
            sb.append(this.createTimeRangeSql(keyFieldName, new TimeRange(param.getStart(), param.getEnd()), true));
        }
        if ((backDayNum = param.getBackDayNum()) != null) {
            timeRange = new TimeRange();
            timeRange.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(backDayNum - 1) * ONE_DAY_TIME)));
            timeRange.setEndTime(now);
            sb.append(this.createTimeRangeSql("last_push_time", timeRange, new boolean[0]));
        }
        if ((recentBrowseDayNum = param.getRecentBrowseDayNum()) != null) {
            timeRange2 = new TimeRange();
            timeRange2.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(recentBrowseDayNum - 1) * ONE_DAY_TIME)));
            timeRange2.setEndTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() + ONE_DAY_TIME)));
            sb.append(this.createTimeRangeSql("last_browse_time", timeRange2, new boolean[0]));
        }
        if ((notFollowDayNum = param.getUnRemindDayNum()) != null) {
            TimeRange timeRange6 = new TimeRange();
            timeRange6.setStartTime(null);
            timeRange6.setEndTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(notFollowDayNum - 1) * ONE_DAY_TIME)));
            sb.append(" AND ((*:* NOT last_remind_time:*) OR ");
            sb.append(this.createTimeRangeSql("last_remind_time", timeRange6, new boolean[0]).replace(" AND ", "")).append(" )");
        }
        log.info("[ Solr Qusery is: {}  ]", (Object)sb.toString());
        return sb.toString();
    }

    private String createEquals(String fieldName, Object value) {
        return " AND " + SolrUtil.equal(fieldName, value) + " ";
    }

    private String createIn(String fieldName, Collection<?> value) {
        return " AND " + SolrUtil.or(fieldName, value) + " ";
    }

    public ConsulterListDto buildConsulterListDto(SolrDocument doc, Integer consulterType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ConsulterListDto dto = new ConsulterListDto();
        dto.setName((String)doc.get((Object)"name"));
        dto.setMobile((String)doc.get((Object)"mobile"));
        dto.setPortrait((String)doc.get((Object)"portrait"));
        dto.setId((Long)doc.get((Object)"c_self_id"));
        dto.setStudentId((Long)doc.get((Object)"student_id"));
        dto.setWenxinOpenId((String)doc.get((Object)"weixin_open_id"));
        Date finallyHoldTime = (Date)doc.get((Object)"finally_hold_time");
        Date now = new Date();
        if (finallyHoldTime != null) {
            finallyHoldTime = this.getDateFromSolr(sdf, finallyHoldTime);
        }
        Integer lessDayNum = 0;
        if (finallyHoldTime != null && finallyHoldTime.after(now) && (lessDayNum = DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).equals(DateUtil.getStartOfDayAccurateToMillSeconde((Date)now)) ? Integer.valueOf(1) : Integer.valueOf((int)((DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).getTime() - DateUtil.getStartOfDayAccurateToMillSeconde((Date)now).getTime()) / ONE_DAY_TIME))) == 0) {
            lessDayNum = 1;
        }
        log.info("lessDayNum is : {} for finallyHoldTime : {} ", (Object)lessDayNum, (Object)finallyHoldTime);
        dto.setTimeRemaining(lessDayNum);
        String inital = (String)doc.get((Object)"pinyin");
        if (GenericsUtils.notNullAndEmpty((Object)inital)) {
            if ((inital = inital.substring(0, 1).toUpperCase()).equals("~")) {
                inital = "#";
            }
        } else {
            inital = "#";
        }
        dto.setInitial(inital);
        dto.setIsInvalid((Integer)doc.get((Object)"is_invalid"));
        dto.setCascadeId((Integer)doc.get((Object)"cascade_id"));
        dto.setConsulterType(consulterType);
        Date birthday = this.getDateFromSolr(sdf, (Date)doc.get((Object)"birthday"));
        dto.setBirthday(birthday);
        dto.setCascadeId((Integer)doc.get((Object)"cascade_id"));
        dto.setConsultSource((Integer)doc.get((Object)"consult_source"));
        dto.setConsultStatus((Integer)doc.get((Object)"consult_status"));
        dto.setDegreeClass(String.valueOf(doc.get((Object)"degree_class")));
        dto.setIntensionLevel((Integer)doc.get((Object)"intension_level"));
        dto.setMail(String.valueOf(doc.get((Object)"mail")));
        dto.setQq(String.valueOf(doc.get((Object)"qq")));
        dto.setAddress(String.valueOf(doc.get((Object)"address")));
        dto.setRelatives((Integer)doc.get((Object)"relatives"));
        dto.setSchool(String.valueOf(doc.get((Object)"school")));
        dto.setSex((Integer)doc.get((Object)"sex"));
        dto.setParentName(String.valueOf(doc.get((Object)"parent_name")));
        dto.setParentMobile(String.valueOf(doc.get((Object)"parent_mobile")));
        dto.setNextRemindTime(this.getDateFromSolr(sdf, (Date)doc.get((Object)"next_remind_time")));
        dto.setCreateTime(this.getDateFromSolr(sdf, (Date)doc.get((Object)"create_time")));
        dto.setLastRemindTime(this.getDateFromSolr(sdf, (Date)doc.get((Object)"last_remind_time")));
        return dto;
    }

    private Date getDateFromSolr(SimpleDateFormat sdf, Date date) {
        if (date == null) {
            return null;
        }
        Long time = date.getTime();
        int timeDiff = TimeZone.getDefault().getRawOffset() - TimeZone.getTimeZone("GMT").getRawOffset();
        Long time1 = time - (long)timeDiff;
        date = new Date(time1);
        log.debug("===== time is : {} ", (Object)sdf.format(date));
        return date;
    }

    public Set<Long> queryConsultIdByTags(String tag, Long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:t_* AND ").append(" org_id:").append(orgId).append(" AND content:*").append(tag).append("*").append(" AND user_id:0 ");
        SolrQuery query = new SolrQuery();
        log.info("[Solr] query tag param:" + sb.toString());
        query.setQuery(sb.toString());
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        StringBuilder fq1 = new StringBuilder("-t_consult_user_id:").append("0");
        query.addFilterQuery(new String[]{fq1.toString()});
        QueryResponse response = null;
        HashSet<Long> consultUserIds = new HashSet<Long>();
        try {
            response = this.getSolr().query("crm_students", (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList list = response.getResults();
            log.info("[Solr] query tag result:" + list.getNumFound());
            for (SolrDocument doc : list) {
                Long userId = (Long)doc.get((Object)"t_consult_user_id");
                if (userId == null) continue;
                log.info("find userId is : {} ", (Object)userId);
                consultUserIds.add(userId);
            }
            if (GenericsUtils.isNullOrEmpty(consultUserIds)) {
                return Collections.emptySet();
            }
            return consultUserIds;
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String queryConsultIdByTagsStr(String tag, Long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:t_* AND ").append(" org_id:").append(orgId).append(" AND content:*").append(tag).append("*").append(" AND user_id:0 ").append(" AND ").append(SolrUtil.notEqual("t_consult_user_id", 0));
        return sb.toString();
    }

    @Override
    public Integer countConsulter(Collection<Integer> cascadeIds, ConsulterListQueryParam param) {
        String queryStr = this.getconsultUserIds(cascadeIds, param);
        SolrQuery query = new SolrQuery();
        query.setQuery(queryStr);
        QueryResponse response = null;
        try {
            log.info("Solr QueryParam=" + query.toString());
            response = this.getSolr().query("crm_consultor", (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList documentList = response.getResults();
            long total = documentList.getNumFound();
            log.info("[Solr] Query count=" + total);
            return (int)total;
        }
        catch (SolrServerException e) {
            log.error("[Solr] query consult user SolrServerException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("[Solr] query consult user IOException", (Throwable)e);
        }
        return 0;
    }

    @Override
    public void updateOldRow(Map<String, String> rs) throws SolrServerException, IOException {
        rs = this.mapKeyToUpper(rs);
        Map<String, Object> insertKeyMap = this.getValueMap(rs);
        log.info("Debug insertKeyMap" + insertKeyMap + "collection:" + "crm_consultor");
        this.update("crm_consultor", insertKeyMap);
    }

    @Override
    public void deleteOldRow(Map<String, String> rs) throws SolrServerException, IOException {
        rs = this.mapKeyToUpper(rs);
        String key = rs.get("ID");
        String query = "id:c_" + key;
        this.delete("crm_consultor", query);
    }

    @Override
    public void insertNewRow(Map<String, String> rs) throws SolrServerException, IOException {
        rs = this.mapKeyToUpper(rs);
        Map<String, Object> insertKeyMap = this.getValueMap(rs);
        this.add("crm_consultor", insertKeyMap);
    }

    private Map<String, Object> getValueMap(Map<String, String> rs) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        log.info("rs map is : {} ", rs);
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        for (String key : new ArrayList<String>(Arrays.asList(keys.split(",")))) {
            key = key.trim().toUpperCase();
            String value = rs.get(key);
            log.info("key is : {} and value is :{} ", (Object)key, (Object)value);
            newValues.put(key, value);
        }
        String id = (String)newValues.get("ID");
        if (id != null) {
            newValues.put("ID", "c_" + id);
            newValues.put("C_SELF_ID", id);
        } else {
            log.info("can not find id field ");
        }
        log.info("ID is : {} ", newValues.get("ID"));
        Object pinyin = newValues.get("PINYIN");
        if (pinyin != null && StringUtils.isNotBlank((CharSequence)pinyin.toString())) {
            char init = pinyin.toString().charAt(0);
            if (init < 'a' || init > 'z') {
                pinyin = "~";
            }
        } else {
            pinyin = "~";
        }
        newValues.put("PINYIN", pinyin);
        if (newValues.get("CUSTOM_SEARCH_VALUE") != null) {
            Object[] array = newValues.get("CUSTOM_SEARCH_VALUE").toString().split(" ");
            ArrayList customSearchValueList = Lists.newArrayList();
            if (array.length > 0) {
                customSearchValueList = Lists.newArrayList((Object[])array);
            }
            newValues.put("CUSTOM_SEARCH_VALUE", customSearchValueList);
        }
        try {
            this.solveFields("c_self_id,org_id,user_id,is_consulter,user_number,relatives,student_id,avatar,campus_org_id".toUpperCase(), newValues, Integer.class);
            this.solveFields("consult_source,intension_level,consult_status,del_status,gender,branch_id,status,cascade_id,is_invalid,manually,area_id".toUpperCase(), newValues, Long.class);
            this.solveFields("longitude,latitude".toUpperCase(), newValues, Double.class);
            this.solveFields("finally_hold_time,last_pull_time,last_push_time,last_invalid_time,last_browse_time,create_time,last_remind_time,update_time,next_remind_Time,birthday".toUpperCase(), newValues, Date.class);
            for (Map.Entry entry : newValues.entrySet()) {
                retMap.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
            }
        }
        catch (Exception e) {
            log.error("can not insert new values cause by : {} ", (Throwable)e);
        }
        log.info("after populate , the valueMap is : {} ", retMap);
        return retMap;
    }
}

