/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.po;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import java.math.BigDecimal;
import java.util.HashSet;

public class StudentClassHour
extends StudentClass {
    private Integer totalCount = 0;
    private Integer finishCount = 0;
    private Integer leftCount = 0;
    private Long totalTime = 0L;
    private Long leftTime = 0L;
    private Long finishedTime = 0L;
    private BigDecimal classHourRatio;
    private Long totalClassHour;
    private Long totalKexiaoClassHour;
    private boolean isArrange = true;

    public StudentClassHour() {
    }

    public BigDecimal getClassHourRatio() {
        BigDecimal total = new BigDecimal(this.totalCount);
        BigDecimal left = new BigDecimal(this.getLeftCount());
        if (this.getLeftCount() <= 0) {
            return BigDecimal.ZERO;
        }
        if (this.totalCount <= 0) {
            return BigDecimal.ZERO;
        }
        this.classHourRatio = left.divide(total, 2, 6);
        return this.classHourRatio;
    }

    public int getLeftCount() {
        this.leftCount = this.totalCount - this.finishCount;
        return this.leftCount;
    }

    public StudentClassHour(String solrId) {
        String[] str = solrId.split("_");
        this.setUserId(Long.parseLong(str[1]));
        this.setCourseId(Long.parseLong(str[2]));
    }

    public static StudentClassHour getInstance(OrgStudentCourse studentCourse) {
        StudentClassHour classHour = new StudentClassHour();
        classHour.setUserId(studentCourse.getUserId());
        classHour.setCourseId(studentCourse.getCourseId());
        classHour.setFinishedTime(0L);
        classHour.setFinishCount(0);
        if (ChargeUnit.isByTime((int)studentCourse.getChargeUnit())) {
            classHour.setTotalTime(studentCourse.getLessonCount().longValue());
        } else {
            classHour.setTotalCount(studentCourse.getLessonCount());
        }
        return classHour;
    }

    public static void main(String[] args) {
        StudentClassHour classHour1 = new StudentClassHour();
        StudentClassHour classHour2 = new StudentClassHour();
        HashSet<StudentClassHour> set = new HashSet<StudentClassHour>();
        set.add(classHour1);
        set.add(classHour2);
        System.out.println(set.size());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StudentClassHour that = (StudentClassHour)o;
        if (this.getUserId() != that.getUserId()) {
            return false;
        }
        return this.getCourseId() == that.getCourseId();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public Integer getFinishCount() {
        return this.finishCount;
    }

    public Long getTotalTime() {
        return this.totalTime;
    }

    public Long getLeftTime() {
        return this.leftTime;
    }

    public Long getFinishedTime() {
        return this.finishedTime;
    }

    public Long getTotalClassHour() {
        return this.totalClassHour;
    }

    public Long getTotalKexiaoClassHour() {
        return this.totalKexiaoClassHour;
    }

    public boolean isArrange() {
        return this.isArrange;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public void setFinishCount(Integer finishCount) {
        this.finishCount = finishCount;
    }

    public void setLeftCount(Integer leftCount) {
        this.leftCount = leftCount;
    }

    public void setTotalTime(Long totalTime) {
        this.totalTime = totalTime;
    }

    public void setLeftTime(Long leftTime) {
        this.leftTime = leftTime;
    }

    public void setFinishedTime(Long finishedTime) {
        this.finishedTime = finishedTime;
    }

    public void setClassHourRatio(BigDecimal classHourRatio) {
        this.classHourRatio = classHourRatio;
    }

    public void setTotalClassHour(Long totalClassHour) {
        this.totalClassHour = totalClassHour;
    }

    public void setTotalKexiaoClassHour(Long totalKexiaoClassHour) {
        this.totalKexiaoClassHour = totalKexiaoClassHour;
    }

    public void setArrange(boolean isArrange) {
        this.isArrange = isArrange;
    }

    @Override
    public String toString() {
        return "StudentClassHour(totalCount=" + this.getTotalCount() + ", finishCount=" + this.getFinishCount() + ", leftCount=" + this.getLeftCount() + ", totalTime=" + this.getTotalTime() + ", leftTime=" + this.getLeftTime() + ", finishedTime=" + this.getFinishedTime() + ", classHourRatio=" + this.getClassHourRatio() + ", totalClassHour=" + this.getTotalClassHour() + ", totalKexiaoClassHour=" + this.getTotalKexiaoClassHour() + ", isArrange=" + this.isArrange() + ")";
    }
}

