/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum StudentLessonStatus {
    NOT_ENROLL(-1, "\u672a\u62a5\u540d\u5b66\u5458", 1),
    ALL(0, "\u5168\u90e8\u5b66\u5458", false, -50),
    STUDYING(1, "\u5728\u8bfb\u5b66\u5458", 2),
    PAST(2, "\u5f80\u671f\u5b66\u5458", 3),
    TO_CHARGE(3, "\u5f85\u7eed\u8d39\u5b66\u5458", 4),
    CURRENT_STU(4, "\u5f53\u671f\u5b66\u5458", 0, "\u5373\u672a\u62a5\u540d\u548c\u5728\u8bfb\u5b66\u5458"),
    BACKLOG_STU(5, "\u4eca\u65e5\u5f85\u529e\u5173\u8054\u5b66\u5458", false, 0),
    UN_KNOW_TYPE(-100, "\u672a\u77e5\u7c7b\u578b", false, -100);

    private int status;
    private String name;
    private boolean needShow;
    private int sort;
    private String desc = "";

    public static StudentLessonStatus getStatus(Integer status) {
        if (status == null) {
            return UN_KNOW_TYPE;
        }
        for (StudentLessonStatus studentLessonStatus : StudentLessonStatus.values()) {
            if (studentLessonStatus.getStatus() != status.intValue()) continue;
            return studentLessonStatus;
        }
        return UN_KNOW_TYPE;
    }

    private StudentLessonStatus(int status, String name, int sort) {
        this(status, name, true, sort);
    }

    private StudentLessonStatus(int status, String name, int sort, String desc) {
        this(status, name, true, sort, desc);
    }

    private StudentLessonStatus(int status, String name, boolean needShow, int sort) {
        this(status, name, needShow, sort, "");
    }

    private StudentLessonStatus(int status, String name, boolean needShow, int sort, String desc) {
        this.status = status;
        this.name = name;
        this.needShow = needShow;
        this.sort = sort;
        this.desc = desc;
    }

    public int getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public boolean needShow() {
        return this.needShow;
    }

    public int getSort() {
        return this.sort;
    }

    public static List<Integer> findSubStatus(int status) {
        StudentLessonStatus statusEnum = StudentLessonStatus.getStatus(status);
        ArrayList allSubStatus = Lists.newArrayList();
        switch (statusEnum) {
            case ALL: {
                allSubStatus.add(StudentLessonStatus.STUDYING.status);
                allSubStatus.add(StudentLessonStatus.TO_CHARGE.status);
                allSubStatus.add(StudentLessonStatus.PAST.status);
                allSubStatus.add(StudentLessonStatus.NOT_ENROLL.status);
                break;
            }
            case STUDYING: {
                allSubStatus.add(StudentLessonStatus.STUDYING.status);
                allSubStatus.add(StudentLessonStatus.TO_CHARGE.status);
                break;
            }
            case CURRENT_STU: {
                allSubStatus.add(StudentLessonStatus.STUDYING.status);
                allSubStatus.add(StudentLessonStatus.TO_CHARGE.status);
                allSubStatus.add(StudentLessonStatus.NOT_ENROLL.status);
                break;
            }
            case BACKLOG_STU: {
                allSubStatus.add(StudentLessonStatus.STUDYING.status);
                allSubStatus.add(StudentLessonStatus.TO_CHARGE.status);
                allSubStatus.add(StudentLessonStatus.NOT_ENROLL.status);
                allSubStatus.add(StudentLessonStatus.PAST.status);
                break;
            }
            default: {
                allSubStatus.add(statusEnum.status);
            }
        }
        return allSubStatus;
    }

    public static Collection<? extends Integer> listAllStatus() {
        ArrayList status = Lists.newArrayList();
        for (StudentLessonStatus sls : StudentLessonStatus.values()) {
            if (sls == UN_KNOW_TYPE) continue;
            status.add(sls.status);
        }
        return status;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

