package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.tianxiao.dal.solr.constant.SolrConfig;
import com.baijia.tianxiao.dal.solr.constant.SolrConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Created by liuxp on 16/5/24.
 */
@Slf4j
public class SolrCommit extends SolrAbstractServiceImpl {

    public void commitSolr() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
            String ip = addr.getHostAddress();// 获得本机IP
            log.info("[Solr] allowed ip={},localhost ip={}", SolrConfig.ALLOW_IP,ip);
            if ("0.0.0.0".equals(SolrConfig.ALLOW_IP) || (StringUtils.isNotBlank(ip) && ip.equals(SolrConfig.ALLOW_IP))) {
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        if (getSolr() == null) {
                            log.debug("[Solr] No Solr config-------");
                            return;
                        }
                        while (true) {
                            log.debug("[Solr] update index-------");
                            try {
                                getSolr().commit(SolrConstant.CRM_STUDENT_COLLECTION, true, true, true);
                                getSolr().commit(SolrConstant.CRM_CONSULT_USER_COLLECTION, true, true, true);
                                getSolr().commit(SolrConstant.STUDENT_COURSE_COLLECTION, true, true, true);
//                                getSolr().commit(SolrConstant.ERP_CLASS_ROOM_COLLECTION, true, true, true);
                                log.info("[Solr] update finish-------");
                                Thread.sleep(5000);
                            } catch (SolrServerException e) {
                                log.error("[Solr] SolrServerException ", e);
                            } catch (IOException e) {
                                log.error("[Solr] IOException ", e);
                            } catch (InterruptedException e) {
                                log.error("[Solr] InterruptedException ", e);
                            } catch (Exception e) {
                                log.error("[Solr] Exception ", e);
                            }
                        }
                    }
                }).start();
            }else {
                log.info("[Solr] This ip is not allowed.ip={}",ip);
            }
        } catch (UnknownHostException e) {
            log.error("[Solr] UnknownHostException", e);
        }
    }
}
