
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.solr.query.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.solr.constant.SolrConstant;
import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.solr.enums.OrgTeacherUseStatus;
import com.baijia.tianxiao.dal.solr.query.OrgTeacherQuery;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Feb 24, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Service
@Slf4j
public class OrgTeacherQueryImpl extends SolrAbstractServiceImpl implements OrgTeacherQuery {

    @Override
    public List<OrgTeacherDocument> queryOrgTeachers(Integer lastId, Integer orgId, Integer useStatus,
        Integer countType, Integer orderType, String searchKey, PageDto pageDto) {

        if (pageDto == null) {
            pageDto = new PageDto();
            pageDto.setPageNum(1);
            pageDto.setPageSize(100);
        }

        log.info("solr with params -- orgID:{}", orgId);

        StringBuilder queryBuilder = new StringBuilder();
        SolrQuery query = new SolrQuery();

        String currentDate = DateUtil.getCurrentYM();
        queryBuilder.append("id:t_* AND  orgId:").append(orgId).append(" AND ")
            .append(SolrUtil.equal("dataMonth", currentDate));

        if (useStatus != null) {
            queryBuilder.append(" AND ").append(SolrUtil.equal("useStatus", useStatus));
        } else {
            queryBuilder.append(" AND ").append(SolrUtil.or("useStatus", OrgTeacherUseStatus.normalStatus));
        }

        TwoTuple<String, Integer> sortRule = getSolrRule(countType, orderType);
        // if (lastId != null && lastId != -1) {
        // if (sortRule.second == 0) {
        // queryBuilder
        // .append(" AND " + SolrUtil.range("orgTeacherId", RangeType.INCLUDE_BOTTOM_EXCLUDE_TOP, -1, lastId));
        // } else {
        // queryBuilder.append(
        // " AND " + SolrUtil.range("orgTeacherId", RangeType.EXCLUDE_BOTTOM_INCLUDE_TOP, lastId, "*"));
        // }
        // }

        if (GenericsUtils.notNullAndEmpty(searchKey)) {
            queryBuilder.append(" AND (").append(SolrUtil.like("mobile", searchKey))
                .append(SolrUtil.like("name", searchKey, Boolean.FALSE)).append(")");
        }

        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int limit = pageDto.getPageSize();
        query.setQuery(queryBuilder.toString());
        query.setStart(start);
        query.setRows(limit);
        query.addSort(sortRule.first, sortRule.second == 0 ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);

        List<OrgTeacherDocument> retList = searchDocumentFromSolr(query, pageDto);

        return retList;
    }

    /**
     * @param solrDocument
     * @return
     */
    private OrgTeacherDocument builderDocument(SolrDocument solrDocument) {
        Map<String, Object> fieldValueMap = solrDocument.getFieldValueMap();
        log.info("======is:{} ", 123);
        Map<String, Object> newFieldValueMap = GenericsUtils.<String, Object> copyMap(fieldValueMap);
        log.info("fieldValueMap is :{} ", newFieldValueMap);
        OrgTeacherDocument solrDocumentRet = new OrgTeacherDocument();
        try {
            BeanUtils.populate(solrDocumentRet, newFieldValueMap);
        } catch (IllegalAccessException | InvocationTargetException e) {
            log.error("error is:{} ", e);
        }
        // BeanInvokeUtils.copyBean(solrDocument, solrDocumentRet);
        return solrDocumentRet;
    }

    public TwoTuple<String, Integer> getSolrRule(Integer countType, Integer orderType) {
        String field = "createTime";
        Integer order = 0;
        switch (countType) {
            case 0:
                field = "createTime";
                break;
            case 1:
                field = "finishedClassTime";
                break;
            case 2:
                field = "hasSignupStudentCount";
                break;
            case 3:
                field = "scoreNum";
                break;
            case 4:
                field = "pauseTime";
                break;
            default:
                field = "createTime";
        }
        if (orderType != null && orderType == 2) {
            order = 1;
        }
        return TupleUtil.tuple(field, order);
    }

    @Override
    public List<OrgTeacherDocument> queryOrgTeachersWithIds(Integer orgId, Collection<Long> teacherIds,
        Boolean...isIdQuery) {
        if (GenericsUtils.isNullOrEmpty(teacherIds)) {
            return GenericsUtils.emptyList();
        }
        boolean isId = (GenericsUtils.notNullAndEmpty(isIdQuery) ? isIdQuery[0] : true); // 默认是走ID查询
        String queryField = isId ? "orgTeacherId" : "teacherUserId";
        log.info("solr with params -- orgID:{}");
        StringBuilder queryBuilder = new StringBuilder();
        SolrQuery query = new SolrQuery();
        queryBuilder.append("id:t_* AND  orgId:").append(orgId).append(" AND ")
            .append(SolrUtil.or(queryField, teacherIds));
        query.setRows(Integer.MAX_VALUE);
        query.setQuery(queryBuilder.toString());
        List<OrgTeacherDocument> retList = searchDocumentFromSolr(query);
        return retList;
    }

    /**
     * @param queryBuilder
     * @param query
     * @return
     */

    private List<OrgTeacherDocument> searchDocumentFromSolr(SolrQuery query, PageDto...pageDtos) {
        PageDto pageDto = GenericsUtils.isNullOrEmpty(pageDtos) ? null : pageDtos[0];
        log.info("[OrgTeacherQueryImpl] query from solr :{} ", query.getQuery());
        QueryResponse response = null;
        try {
            response = getSolr().query(SolrConstant.ERP_CLASS_ROOM_COLLECTION, query, SolrRequest.METHOD.POST);
        } catch (SolrServerException | IOException e) {
            GenericsUtils.logErrorAndInfo(log, e,
                "[OrgTeacherQueryImpl] can not find orgTeacherDocument with query :{} ", query.getQuery());
            throw new RuntimeException("solr service error !");
        }

        List<OrgTeacherDocument> retList = Lists.newArrayList();
        SolrDocumentList documentList = response.getResults();
        for (Iterator<SolrDocument> iterator = documentList.iterator(); iterator.hasNext();) {
            OrgTeacherDocument solrDocument = builderDocument(iterator.next());
            retList.add(solrDocument);
        }
        if (pageDto != null) {
            long total = documentList.getNumFound();
            pageDto.setCount((int) total);
            log.info("find totalCount is :{} and PageDto is:{} ", total, pageDto);
        }
        return retList;
    }

}
