package com.baijia.tianxiao.dal.solr.po;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import org.codehaus.jackson.annotate.JsonIgnore;

import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.Data;

/**
 * Created by liuxp on 16/4/28.
 */
@Data
public class StudentStatusStatistics {
    private int status;
    private String name;
    private long number;
    @JsonIgnore
    private int sort;
    private String desc;

    public static List<StudentStatusStatistics> getDefaut() {
        List<StudentStatusStatistics> list = new ArrayList<>();
        for (StudentLessonStatus status : StudentLessonStatus.values()) {
            if (!status.needShow()) {
                continue;
            }
            StudentStatusStatistics statistics = new StudentStatusStatistics();
            statistics.setStatus(status.getStatus());
            statistics.setName(status.getName());
            statistics.setNumber(0L);
            statistics.setSort(status.getSort());
            statistics.setDesc(status.getDesc());
            list.add(statistics);
        }
        Collections.sort(list, new Comparator<StudentStatusStatistics>() {
            @Override
            public int compare(StudentStatusStatistics o1, StudentStatusStatistics o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        return list;
    }

    public void setNumberFromMap(Map<Integer, Integer> countMap, List<Integer> status) {
        if (GenericsUtils.notNullAndEmpty(status)) {
            for (int statusIndex : status) {
                this.number += (countMap.get(statusIndex) == null ? 0 : countMap.get(statusIndex));
            }
        }
    }

}