
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.solr.enums;

import java.util.Map;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Sep 9, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public enum PCConsultOrderEnum {

    MOBILE("mobile", "mobile"),
    NAME("name", "pinyin", "name"), 
    MAIL("mail", "mail"),
    QQ("qq", "qq"),
    DEGREECLASS(
        "degreeClass", "degree_class"), 
    ADDRESS("address", "address"),
    RELATIVES("relatives",
            "relatives"), 
    BIRTHDAY("birthday", "birthday"), 
    SCHOOL("school", "school"),
    // CASCADE_ID("cascadeId","cascade_id"),
    INTENSION_LEVEL("intensionLevel", "intension_level"), 
    INTENSION_LEVEL_STR("intensionLevelStr", "intension_level"),
    CONSULT_SOURCE("consultSource",
        "consult_source"),
    PARENT_MOBILE("parentMobile", "parent_mobile"), 
    PARENT_NAME("parentName",
            "parent_name"),
    CONSULT_STATUS("consultStatus", "consult_status"), 
    SEX("sex",
                "sex"),
    NEXT_REMIND_TIME("nextRemindTime", "next_remind_time"), 
    LAST_REMIND_TIME("lastRemindTime", "last_remind_time"),
    LAST_REMIND_TIME_STR("lastRemindTimeStr", "last_remind_time"),
    CREATE_TIME("createTime", "create_time"),
    CREATE_TIME_STR("createTimeStr", "create_time"),
    TAG("tag", "tag", "tag"),
    CUSTOM_SEARCH_VALUE("customSearchValue", "custom_search_value", "custom_search_value"),
    EMPTY("", "", "");

    public String orderName;
    public String matchField;
    public String queryField;

    private PCConsultOrderEnum(String orderName, String matchField) {
        this(orderName, matchField, null);
    }

    private PCConsultOrderEnum(String orderName, String matchField, String queryField) {
        this.orderName = orderName;
        this.matchField = matchField;
        this.queryField = queryField;
    }

    private static Map<String, PCConsultOrderEnum> sourceMap = Maps.newHashMap();

    static {
        for (PCConsultOrderEnum consultEnum : PCConsultOrderEnum.values()) {
            sourceMap.put(consultEnum.orderName, consultEnum);
        }
    }

    private static String PINYIN = "pinyin";

    public static String getMatchField(String orderName) {
        return getMatchFieldWithDefault(orderName, PINYIN, false);
    }

    public static String getMatchFieldWithDefault(String orderName, String defaultField, boolean isQuery) {
        String ret = null;
        PCConsultOrderEnum consultEnum = null;
        if (GenericsUtils.notNullAndEmpty(orderName)) {
            consultEnum = sourceMap.get(orderName);
        }
        if (GenericsUtils.isNullOrEmpty(consultEnum)) {
            consultEnum = EMPTY;
        }
        if (consultEnum != null) {
            if (isQuery && GenericsUtils.notNullAndEmpty(consultEnum.queryField)) {
                ret = consultEnum.queryField;
            } else {
                ret = consultEnum.matchField;
            }
        }
        if (GenericsUtils.isNullOrEmpty(ret)) {
            ret = defaultField;
        }
        log.debug("sortName:{} ,and defaultField:{} , find matchField:{}", orderName, defaultField, ret);
        return ret;
    }
    
    public static void main(String[] args) {
        String matchField2 = getMatchField("degreeClass");
        System.out.println(matchField2);
    }

}
