package com.baijia.tianxiao.dal.solr.dto;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.baijia.tianxiao.dal.solr.enums.OpType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.enums.TimeType;

import lombok.Data;

/**
 * Created by liuxp on 16/4/28.
 */
@Data
public class StudentQueryParam {
    private StudentLessonStatus status;
    private String searchKey;
    private OpType opType;
    private Long number;
    private Integer lessonStatus;// 排课转态
    private Integer leftMinClassHour;
    private Integer leftMaxClassHour;
    private TimeType followTime;
    private TimeType createTime;
    private TimeType enrollTime;
    private Long orgId;
    private Integer cascadeId; 
    private Integer gender;
    private Set<Long> studentIds = new HashSet<>();

    private String dateFieldKey;
    private Date start;
    private Date end;

    //用于PC端参数传递
    private String queryStr;
    private String queryValue;

    // 后端业务传递参数字段----begin------
    private boolean needQueryByAuthority;
    private boolean needSortLeftTimeWithAccount;
    private Integer orgNumber;
    private List<Long> addCascadeIds;
    //排序规则,默认升序0:升序,1:降序
    private int orderType = 0;
    //排序字段
    private String orderName;
    private boolean needClassInfo;
    private Set<Long> ownCourseIds = new HashSet<>();
    //可笑2.0需求
    private Integer infoFillStatus; //1. 2. 3.
    // 后端业务传递参数字段----end------
    
    
    
    public Set<Long> getStudentIds(){
        return this.studentIds;
    }
    
    /**
     * 判断当前的请求是否没有添加任何过滤条件<br/>
     * 如果没有添加任何过滤条件,则直接走DB,避免实时性的更新solr导致solr出现未知异常
     * TODO solr 服务需要好好进行优化
     * @return
     */
    public boolean isNotFilterCondition(){
        
        return false;
    }

}
