package com.baijia.tianxiao.dal.solr.dto;

import com.baijia.tianxiao.annotation.DataTransmissionMark;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

import java.util.Date;

/**
 * Created by liuxp on 16/4/28.
 */
@Data
public class StudentDto {
    private Long studentId;

    private String name;

    private String mobile;

    private String weixin;

    private String avatarUrl;

    private Long avatar;

    private Long userId;

    private Integer gender;

    private String pinyin;

    private Date createTime;

    private Date lastRemindTime;

    private int finishClassHour = 0;// 已完成课次

    private int leftClassHour = 0;// 剩余课次

    @JsonIgnore
    private int totalTime = 0;// 总课时

    @JsonIgnore
    private int finishedTime = 0;// 已上课时

    private String finishClassHourForKexiao = "";

    private String leftClassHourForKexiao = "";

    private String totalClassHourForKeixao = "";

    private String remainTuition = "--";// 剩余学费

    private Integer chargeUnit; // 计费单位

    private String className = "未排课";// 班级名称

    private String initial;// 首字母

    private Long courseId;

    private Integer stuLessonStatus; // 0.未报名 1.在读 2.往期 3.待续费

    private String typeMark;// 学员类型

    private String showClassInfo; // 展示课次信息 12/31小时

    @JsonIgnore
    @DataTransmissionMark("是否有排课")
    private boolean hasLesson;

    public void setTypeMark(String typeMark) {
        this.typeMark = typeMark;
    }

    public void setStuLessonStatus(Integer stuLessonStatus) {
        this.stuLessonStatus = stuLessonStatus;
    }

}
