
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.solr.dto;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Feb 20, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@Slf4j
public class OrgTeacherDocument {

    private String id;
    private Long orgId;
    private Long orgTeacherId;
    private Long teacherUserId; // UserId
    private Long createTime; // 创建时间
    private Long pauseTime; // 停用时间
    private String name; // 姓名
    private String mobile = ""; // 电话
    private Integer useStatus = 0; // 0:正常 1:清除 2:删除
    private Long avatarStorageId = -1L; // 老师头像的storageId
    private String dataMonth; // 哪个月的数据 2017-02

    private Integer hasSignupStudentCount = 0; // 已授学生数
    private Integer arrangeStudentCount = 0; // 已排学生数
    private long scoreNum = 0; // 评价得分
    private Integer arrangeClassTime = 0; // 已排课时数(minute)
    private Integer finishedClassTime = 0; // 已完成的课时数(minute)

    /**
     * @param userId
     * @param dataMonth
     * @return
     */
    public static OrgTeacherDocument newInstance(Long userId, String dataMonth) {
        if (GenericsUtils.isNullOrEmpty(dataMonth)) {
            dataMonth = null;
        }
        OrgTeacherDocument newInstance = OrgTeacherDocument.newInstance();
        newInstance.setId(createId(userId, dataMonth));
        newInstance.setTeacherUserId(userId);
        newInstance.setDataMonth(dataMonth);
        return newInstance;
    }

    private static final String ID_FORMAT = "t_%s_%s";

    /**
     * @param userId
     * @param dataMonth
     * @return
     */
    public static String createId(Long userId, String dataMonth) {
        return String.format(ID_FORMAT, userId, dataMonth);
    }

    /**
     * 
     */
    private static OrgTeacherDocument newInstance() {
        return new OrgTeacherDocument();
    }

    /**
     * @param listByQuery
     * @return
     */
    @SuppressWarnings("unchecked")
    public static List<OrgTeacherDocument> buidOrgTeacherDocumentFromMap(List<Map<String, Object>> listByQuery) {
        List<OrgTeacherDocument> retDocuments = Lists.newArrayList();
        for (Map<String, Object> valueMap : listByQuery) {
            OrgTeacherDocument bean = new OrgTeacherDocument();
            try {
                BeanUtils.populate(bean, valueMap);
            } catch (IllegalAccessException | InvocationTargetException e) {
                log.info("can not populate bean from map:{} ", valueMap);
            }
            retDocuments.add(bean);
            bean.setCreateTime(
                Long.parseLong(((Map<String, Object>) (valueMap.get("createTime"))).get("$numberLong").toString()));
        }
        return retDocuments;
    }

}
