/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.po;

import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;

public class StudentStatusStatistics {
    private int status;
    private String name;
    private long number;
    @JsonIgnore
    private int sort;
    private String desc;

    public static List<StudentStatusStatistics> getDefaut() {
        ArrayList<StudentStatusStatistics> list = new ArrayList<StudentStatusStatistics>();
        for (StudentLessonStatus status : StudentLessonStatus.values()) {
            if (!status.needShow()) continue;
            StudentStatusStatistics statistics = new StudentStatusStatistics();
            statistics.setStatus(status.getStatus());
            statistics.setName(status.getName());
            statistics.setNumber(0L);
            statistics.setSort(status.getSort());
            statistics.setDesc(status.getDesc());
            list.add(statistics);
        }
        Collections.sort(list, new Comparator<StudentStatusStatistics>(){

            @Override
            public int compare(StudentStatusStatistics o1, StudentStatusStatistics o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        return list;
    }

    public void setNumberFromMap(Map<Integer, Integer> countMap, List<Integer> status) {
        if (GenericsUtils.notNullAndEmpty(status)) {
            for (int statusIndex : status) {
                this.number += (long)(countMap.get(statusIndex) == null ? 0 : countMap.get(statusIndex));
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public long getNumber() {
        return this.number;
    }

    public int getSort() {
        return this.sort;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNumber(long number) {
        this.number = number;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StudentStatusStatistics)) {
            return false;
        }
        StudentStatusStatistics other = (StudentStatusStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getNumber() != other.getNumber()) {
            return false;
        }
        if (this.getSort() != other.getSort()) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StudentStatusStatistics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $number = this.getNumber();
        result = result * 59 + (int)($number >>> 32 ^ $number);
        result = result * 59 + this.getSort();
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        return result;
    }

    public String toString() {
        return "StudentStatusStatistics(status=" + this.getStatus() + ", name=" + this.getName() + ", number=" + this.getNumber() + ", sort=" + this.getSort() + ", desc=" + this.getDesc() + ")";
    }
}

