package com.baijia.tianxiao.dal.solr.enums;

import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by liuxp on 16/4/26.
 */
public enum TimeType {
    TODAY(1,"今天"),
    YESTERDAY(2,"昨天"),
    THIS_WEEK(3,"本周"),
    LAST_WEEK(4,"上周"),
    THIS_MONTH(5,"本月"),
    LAST_MONTH(6,"上月"),
    THIS_SEASON(7,"本季度"),
    LAST_SEASON(8,"上季度");

    private int code;
    private String desc;

    TimeType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TimeType getTimeTypeByCode(Integer code){
        if(code==null || code==0){
            return null;
        }
        if(code<1 || code>8){
            return TODAY;
        }else {
            return TimeType.values()[code-1];
        }
    }

    public TimeRange timeRange(){
        TimeRange range = new TimeRange();
        Date start = null,end = null;
        Calendar calendar = Calendar.getInstance();
        switch (this){
            case YESTERDAY:
                end = DateUtil.getStartOfDay(new Date());
                calendar.add(Calendar.DAY_OF_MONTH,-1);
                start = DateUtil.getStartOfDay(calendar.getTime());
                break;
            case THIS_WEEK:
                start = DateUtil.getStartOfDay(getMonday(Calendar.getInstance()));
                calendar.setTime(start);
                calendar.add(Calendar.DAY_OF_MONTH,7);
                end = calendar.getTime();
                break;
            case LAST_WEEK:
                end = DateUtil.getStartOfDay(getMonday(calendar));
                calendar.add(Calendar.WEEK_OF_YEAR,-1);
                start = DateUtil.getStartOfDay(getMonday(calendar));
                break;
            case THIS_MONTH:
                start = DateUtil.getFirstDate(new Date());
                calendar.setTime(start);
                calendar.add(Calendar.MONTH,1);
                end = calendar.getTime();
                break;
            case LAST_MONTH:
                end = DateUtil.getFirstDate(new Date());
                calendar = Calendar.getInstance();
                calendar.add(Calendar.MONTH,-1);
                start = DateUtil.getFirstDate(calendar.getTime());
                break;
            case THIS_SEASON:
                calendar = Calendar.getInstance();
                int month = getSeasonFirstMonth(calendar);
                calendar.set(Calendar.MONTH,month);
                start = DateUtil.getFirstDate(calendar.getTime());
                calendar.setTime(start);
                calendar.add(Calendar.MONTH,3);
                end = calendar.getTime();
                break;
            case LAST_SEASON:
                int thisMonth = getSeasonFirstMonth(calendar);
                calendar.set(Calendar.MONTH,thisMonth);
                end = DateUtil.getFirstDate(calendar.getTime());
                Calendar lastSeasonCalendar = Calendar.getInstance();
                lastSeasonCalendar.add(Calendar.MONTH,-3);
                int lastSeasonMonth = getSeasonFirstMonth(lastSeasonCalendar);
                lastSeasonCalendar.set(Calendar.MONTH,lastSeasonMonth);
                start = DateUtil.getFirstDate(lastSeasonCalendar.getTime());
                break;
            default:
                start = DateUtil.getStartOfDay(calendar.getTime());
                calendar.add(Calendar.DAY_OF_MONTH,1);
                end = DateUtil.getStartOfDay(calendar.getTime());
                break;
        }
        range.setStartTime(start);
        range.setEndTime(end);
        return range;
    }

    /**
     * 获取当周的周一
     *
     * @return
     */
    private Date getMonday(Calendar cal) {
        int i = cal.get(Calendar.DAY_OF_WEEK);
        if (i == 1) {
            i = 8;
        }
        cal.add(Calendar.DAY_OF_MONTH, -(i - 2));
        return cal.getTime();
    }

    //获取季度的第一个月，月份为从0~11
    private int getSeasonFirstMonth(Calendar date){
        int month = date.get(Calendar.MONTH);
        for(int i=-1;i<12;i = i+3){
            if(month<=i){
                return i-2;
            }
        }
        return -1;
    }

    public static void main(String[] args) {
        for(TimeType type:TimeType.values()){
            System.out.println(type.desc+":"+type.timeRange());
        }
    }
}
