package com.baijia.tianxiao.dal.solr.enums;

import com.google.common.collect.Lists;

import java.util.Collection;
import java.util.List;


/**
 * Created by liuxp on 16/4/28.
 */
public enum StudentLessonStatus {
    NOT_ENROLL(-1, "未报名学员",1),
    ALL(0, "全部学员", false,-50), 
    STUDYING(1, "在读学员",2),
    PAST(2, "往期学员",3), 
    TO_CHARGE(3,"待续费学员",4),
    CURRENT_STU(4, "当期学员",0,"即未报名和在读学员"),
    BACKLOG_STU(5, "今日待办关联学员", false,0),//即未报名和在读学员和往期学员

    UN_KNOW_TYPE(-100, "未知类型", false,-100);

    private int status;
    private String name;
    private boolean needShow;
    private int sort; //展示顺序
    private String desc = "";

    public static StudentLessonStatus getStatus(Integer status) {
        if (status == null) {
            return UN_KNOW_TYPE;
        }
        for (StudentLessonStatus studentLessonStatus : StudentLessonStatus.values()) {
            if (studentLessonStatus.getStatus() == status) {
                return studentLessonStatus;
            }
        }
        return UN_KNOW_TYPE;
    }

    private StudentLessonStatus(int status, String name,int sort) {
        this(status, name, true,sort);
    }
    
    private StudentLessonStatus(int status, String name,int sort,String desc) {
        this(status, name, true,sort,desc);
    }

    private StudentLessonStatus(int status, String name, boolean needShow,int sort) {
        this(status,name,needShow,sort,"");
    }
    
    private StudentLessonStatus(int status, String name, boolean needShow,int sort,String desc) {
        this.status = status;
        this.name = name;
        this.needShow = needShow;
        this.sort = sort;
        this.desc = desc;
    }

    public int getStatus() {
        return status;
    }

    public String getName() {
        return name;
    }

    public boolean needShow() {
        return this.needShow;
    }

    public int getSort() {
        return sort;
    }


    public static List<Integer> findSubStatus(int status) {
        StudentLessonStatus statusEnum = getStatus(status);
        List<Integer> allSubStatus = Lists.newArrayList();
        switch (statusEnum) {
            case ALL:
                allSubStatus.add(STUDYING.status);
                allSubStatus.add(TO_CHARGE.status);
                allSubStatus.add(PAST.status);
                allSubStatus.add(NOT_ENROLL.status);
                break;
            case STUDYING:
                allSubStatus.add(STUDYING.status);
                allSubStatus.add(TO_CHARGE.status);
                break;
            case CURRENT_STU:
                allSubStatus.add(STUDYING.status);
                allSubStatus.add(TO_CHARGE.status);
                allSubStatus.add(NOT_ENROLL.status);
                break;
            case BACKLOG_STU:
            	allSubStatus.add(STUDYING.status);
                allSubStatus.add(TO_CHARGE.status);
                allSubStatus.add(NOT_ENROLL.status);
                allSubStatus.add(PAST.status);
                break;
            
            default:
                allSubStatus.add(statusEnum.status);
        }
        return allSubStatus;
    }

    /**
     * @return
     */
    public static Collection<? extends Integer> listAllStatus() {
        List<Integer> status = Lists.newArrayList();
        for (StudentLessonStatus sls : StudentLessonStatus.values()) {
            if (sls != StudentLessonStatus.UN_KNOW_TYPE) {
                status.add(sls.status);
            }
        }
        return status;
    }

    /**
    * @return the desc
    */
    
    public String getDesc() {
    
        return desc;
    }

    /**
     * @param desc the desc to set
     */
    
    public void setDesc(String desc) {
    
        this.desc = desc;
    }
}
