package com.baijia.tianxiao.dal.solr.enums;

/**
 * Created by liuxp on 16/4/28.
 */
public enum OpType {
    FOLLOW(1, "最近7天需要跟进的学员"),
    ENROLL(2, "最近7天报班的学员"),
    CREATE(3, "最近7天创建的学员");

    private int type;
    private String name;

    private OpType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public static OpType getOpType(Integer opType) {
        if (opType == null || opType == 0) {
            return null;
        }
        if (opType > 0 && opType < 4) {
            return OpType.values()[opType - 1];
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }
}

