package com.baijia.tianxiao.dal.solr.po;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Created by liuxp on 16/5/19.
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StudentClassHour extends StudentClass {
    private Integer totalCount =0;// 剩余课次
    private Integer finishCount = 0;// 已完成课次
    private Integer leftCount = 0;// 已完成课次
    private Long totalTime = 0L;// 总课时
    private Long leftTime = 0L;// 剩余课时
    private Long finishedTime = 0L;// 已完成课时
    private BigDecimal classHourRatio;// (剩余课时/总排课课时)

    private Long totalClassHour;// 总排的时间,单位分钟
    private Long totalKexiaoClassHour;// 总课消时间,单位分钟

    private boolean isArrange = true; // 课时计算是否是根据排课记录设置的,如果有报班但没有排课记录,这个值会是false

    public StudentClassHour() {

    }

    public BigDecimal getClassHourRatio() {
        BigDecimal total = new BigDecimal(totalCount);
        BigDecimal left = new BigDecimal(getLeftCount());
        if (getLeftCount() <= 0) {
            return BigDecimal.ZERO;
        }
        if (totalCount <= 0) {
            return BigDecimal.ZERO;
        }
        this.classHourRatio = left.divide(total, 2, BigDecimal.ROUND_HALF_EVEN);
        return this.classHourRatio;
    }

    public int getLeftCount() {
        this.leftCount = totalCount - finishCount;

        return this.leftCount;
    }

    public StudentClassHour(String solrId) {
        String[] str = solrId.split("_");
        setUserId(Long.parseLong(str[1]));
        setCourseId(Long.parseLong(str[2]));
    }

    public static StudentClassHour getInstance(OrgStudentCourse studentCourse){
        StudentClassHour classHour = new StudentClassHour();
        classHour.setUserId(studentCourse.getUserId());
        classHour.setCourseId(studentCourse.getCourseId());
        classHour.setFinishedTime(0L);
        classHour.setFinishCount(0);
        if(ChargeUnit.isByTime(studentCourse.getChargeUnit())){
            classHour.setTotalTime(studentCourse.getLessonCount().longValue());
        }else{
            classHour.setTotalCount(studentCourse.getLessonCount());
        }
        return classHour;
    }

    public static void main(String[] args) {
        StudentClassHour classHour1 = new StudentClassHour();
        StudentClassHour classHour2 = new StudentClassHour();
        Set<StudentClassHour> set = new HashSet<>();
        set.add(classHour1);
        set.add(classHour2);
        System.out.println(set.size());

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StudentClassHour that = (StudentClassHour) o;

        if (getUserId() != that.getUserId()) return false;
        return getCourseId() == that.getCourseId();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

}
