/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.solr.dto;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.beanCopy.BeanMethodInvoke;
import com.baijia.tianxiao.beanCopy.InvokeExclude;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.baijia.tianxiao.dal.solr.enums.PCConsultOrderEnum;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;

import lombok.Data;
import lombok.ToString;

@Data
@ToString(callSuper = true)
public class ConsulterListQueryParam {

    @InvokeExclude
    public static final String CASCADEIDS_SPERATOR = ",";

    @InvokeExclude
    private Integer fromMerge; // 查询来源是否是线索合并页面
    @InvokeExclude
    private Integer consulterType;// 列表类型 1-"我的线索" ; 2-"公共池";3-"7天未跟进",4-"下属线索";5-"无效线索"
    private Integer sex;// 性别
    private Integer consultSource; // 线索来源
    private Integer consultStatus;// 跟进状态
    private Integer intentLevel;// 意向级别
    private Integer lastRemindTimeState;// 最后跟进时间 1-今天 2-昨天 3-本周 4-上周 5-本月 6-上月 7-本季度 8-上季度
    private String minRemainingDay;// 剩余跟进时间 起始 单位:天
    private String maxRemainingDay;// 剩余跟进时间 结束 单位:天
    private Integer notFollowDayNum;// 最近几天未跟进 单位:天
    private Integer remindDayNum;// 最近几天待跟进 单位：天
    private Integer recentBrowseDayNum;// 最近几天内浏览 单位：天
    private Integer backDayNum;// 最近几天内回归 单位：天
    private Integer createDayNum;// 最近几天内创建 单位：天
    @InvokeExclude
    private Integer isInvalid = 0;// 线索 是否失效
    @InvokeExclude
    private Integer isConsulter = 1;// 是否是线索
    private Integer unRemindDayNum;// n天未跟进
    @InvokeExclude
    private Long orgId;// 线索所属机构

    private String keyFieldName;// 搜索关键字的字段
    private String keyword;// 关键词
    private Integer invalidDayNum;// 最近几天内置为无效 单位：天

    // 属性名称(排序使用)
    private String propName;
    // 属性值(排序使用)asc/desc，这个字段默认就是0，如果有变化,说明进行了自定义排序,则其它相关字段一定不为null
    @InvokeExclude
    private Integer sortType;

    // 数据传输字段
    @InvokeExclude
    private boolean needTagFilterQuery;
    @InvokeExclude
    private String cascadeIds;// 查询指定账号集合下的数据 cascadeIds-子账号id以逗号分隔 *****(solr查询中不使用该字段)****

    public Integer getMinRemainingDay() {//兼容ios 非法传参 rilegoule
        if(StringUtils.isNotBlank(this.minRemainingDay) && !this.minRemainingDay.contains("null")){
            return Integer.parseInt(this.minRemainingDay);
        }
        return null;
    }

    public Integer getMaxRemainingDay() {
    	if(StringUtils.isNotBlank(this.maxRemainingDay) && !this.maxRemainingDay.contains("null") ){
    		return Integer.parseInt(this.maxRemainingDay);
    	}
    	return null;
    }


    public List<Integer> listConsultSource() {
        List<Integer> list = new ArrayList<Integer>();
        if (this.consultSource == null) {
            return list;
        } else {
            // 见 com.baijia.tianxiao.dal.push.constant.MessageSource
            // 发活动、抽奖 都算作活动类型
            if (this.consultSource.intValue() == 6 || this.consultSource.intValue() == 7) {
                list.add(6);
                list.add(7);
            } else {
                list.add(this.consultSource);
            }
            return list;
        }
    }

    public TwoTuple<String, Integer> getSortRule() {
        String fieldName = "pinyin"; //
        Integer sortType = this.getSortType(); // 0/1 --- asc/desc
        if (sortType == null) {
            sortType = 0;
        }
        fieldName = PCConsultOrderEnum.getMatchField(this.propName);
        return TupleUtil.tuple(fieldName, sortType);
    }

    @SuppressWarnings("unchecked")
    public boolean needFilter() {
        BeanMethodInvoke<ConsulterListQueryParam> findBeanMethodInovker =
            (BeanMethodInvoke<ConsulterListQueryParam>) BeanInvokeUtils.findBeanMethodInovker(this.getClass());
        List<String> fieldNames = findBeanMethodInovker.getFieldNames();
        for (String fieldName : fieldNames) {
            Invoker<ConsulterListQueryParam> fieldReader = findBeanMethodInovker.getFieldReader(fieldName);
            Object invoke = fieldReader.invoke(this);
            if (invoke != null) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        ConsulterListQueryParam clqp = new ConsulterListQueryParam();
        // clqp.setBackDayNum(2);
        boolean needFilter = clqp.needFilter();
        System.out.println("needFilter " + needFilter);
    }

}
