/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.tianxiao.dal.solr.dto.ClassRoomQueryParam;
import com.baijia.tianxiao.dal.solr.dto.ClassRoomSolrDto;
import com.baijia.tianxiao.dal.solr.query.ClassRoomQuery;
import com.baijia.tianxiao.dal.solr.query.impl.SolrAbstractServiceImpl;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ClassRoomQueryImpl
extends SolrAbstractServiceImpl
implements ClassRoomQuery {
    private static final Logger log = LoggerFactory.getLogger(ClassRoomQueryImpl.class);
    private static final String KEYS = "ID,ORG_ID,ROOM_NAME,ROOM_SIZE,DEL_STATUS,CREATE_TIME,RECYCLE_STATUS,RECYCLE_TIME,ARRANGED_COUNT,ARRANGED_MINUTES";

    @Override
    public void insertNewRow(Map<String, String> rs) throws SolrServerException, IOException {
        Map<String, Object> insertMap = this.getInsertMap(rs);
        this.add("erp_classroom", insertMap);
    }

    private Map<String, Object> getInsertMap(Map<String, String> rowMap) {
        Map<String, Object> upperKeyMap = this.getUpperKeyMap(rowMap);
        Map<String, Object> result = this.dealUpperKeyMap(upperKeyMap);
        return result;
    }

    private Map<String, Object> getUpperKeyMap(Map<String, String> rowMap) {
        HashMap upperKeyMap = Maps.newHashMap();
        ArrayList keyList = Lists.newArrayList(Arrays.asList(KEYS.split(",")));
        for (String key : keyList) {
            String value = rowMap.get(key);
            upperKeyMap.put(key, value);
        }
        String roomId = (String)upperKeyMap.get("ID");
        if (roomId != null) {
            upperKeyMap.put("ID", "erp_" + roomId);
            upperKeyMap.put("ROOM_ID", roomId);
            upperKeyMap.put("MONTH", DateUtil.getThisMonth());
        } else {
            log.info("can not find id field ");
        }
        return upperKeyMap;
    }

    private Map<String, Object> dealUpperKeyMap(Map<String, Object> upperKeyMap) {
        HashMap result = Maps.newHashMap();
        try {
            this.solveFields("room_size,del_status,recycle_status,arranged_count,arranged_minutes,month".toUpperCase(), upperKeyMap, Integer.class);
            this.solveFields("room_id,org_id".toUpperCase(), upperKeyMap, Long.class);
            this.solveFields("create_time,recycle_time".toUpperCase(), upperKeyMap, Date.class);
            for (Map.Entry<String, Object> entry : upperKeyMap.entrySet()) {
                result.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        catch (Exception e) {
            log.error("can not insert new values cause by : {} ", (Throwable)e);
        }
        log.info("after populate , the valueMap is : {} ", (Object)result);
        return result;
    }

    @Override
    public List<ClassRoomSolrDto> queryClassRoom(ClassRoomQueryParam param, PageDto pageDto) throws IOException, SolrServerException {
        ArrayList result = Lists.newArrayList();
        String querySql = this.getClassRoomListQueryString(param);
        log.info("[query string] is : {} ,param={}", (Object)querySql, (Object)param);
        SolrQuery query = new SolrQuery();
        query.setQuery(querySql);
        this.dealOrder(query, param.getOrder(), param.getRoomName());
        int start = 0;
        int limit = Integer.MAX_VALUE;
        if (pageDto != null) {
            start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            limit = pageDto.getPageSize();
        }
        query.setStart(Integer.valueOf(start));
        query.setRows(Integer.valueOf(limit));
        QueryResponse response = this.getSolr().query("erp_classroom", (SolrParams)query, SolrRequest.METHOD.POST);
        SolrDocumentList documentList = response.getResults();
        Iterator iterator = documentList.iterator();
        while (iterator.hasNext()) {
            result.add(this.buildClassRoomSolrDto((SolrDocument)iterator.next()));
        }
        long total = documentList.getNumFound();
        log.debug("[solr query pageCount]={}", (Object)total);
        if (pageDto == null) {
            pageDto = new PageDto();
        }
        pageDto.setCount(Integer.valueOf((int)total));
        return result;
    }

    private String getClassRoomListQueryString(ClassRoomQueryParam param) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:erp_* AND del_status:0 AND month:" + DateUtil.getThisMonth());
        sb.append(this.createEquals("org_id", param.getOrgId()));
        if (param.getRecycleStatus() != null) {
            sb.append(this.createEquals("recycle_status", param.getRecycleStatus()));
        }
        if (param.getRoomName() != null) {
            sb.append(this.createEquals("room_name", "*" + param.getRoomName() + "*"));
        }
        return sb.toString();
    }

    private String createEquals(String fieldName, Object value) {
        return " AND " + SolrUtil.equal(fieldName, value) + " ";
    }

    private void dealOrder(SolrQuery query, Integer order, String roomName) {
        if (StringUtils.isNotBlank((CharSequence)roomName)) {
            query.addSort("recycle_time", SolrQuery.ORDER.asc);
            return;
        }
        if (order == null) {
            query.addSort("create_time", SolrQuery.ORDER.desc);
        } else {
            switch (order) {
                case 1: {
                    query.addSort("create_time", SolrQuery.ORDER.desc);
                    break;
                }
                case 2: {
                    query.addSort("create_time", SolrQuery.ORDER.asc);
                    break;
                }
                case 3: {
                    query.addSort("arranged_minutes", SolrQuery.ORDER.desc);
                    break;
                }
                case 4: {
                    query.addSort("arranged_minutes", SolrQuery.ORDER.asc);
                    break;
                }
                case 5: {
                    query.addSort("recycle_time", SolrQuery.ORDER.desc);
                    break;
                }
                case 6: {
                    query.addSort("recycle_time", SolrQuery.ORDER.asc);
                }
            }
        }
    }

    private ClassRoomSolrDto buildClassRoomSolrDto(SolrDocument doc) {
        ClassRoomSolrDto classRoom = new ClassRoomSolrDto();
        classRoom.setRoomId((Long)doc.get((Object)"room_id"));
        classRoom.setOrgId((Long)doc.get((Object)"org_id"));
        classRoom.setRoomName((String)doc.get((Object)"room_name"));
        classRoom.setRoomSize((Integer)doc.get((Object)"room_size"));
        classRoom.setDelStatus((Integer)doc.get((Object)"del_status"));
        classRoom.setRecycleStatus((Integer)doc.get((Object)"recycle_status"));
        classRoom.setCreateTime(this.getDateFromSolr((Date)doc.get((Object)"create_time")));
        classRoom.setRecycleTime(this.getDateFromSolr((Date)doc.get((Object)"recycle_time")));
        classRoom.setArrangedCount((Integer)doc.get((Object)"arranged_count"));
        classRoom.setArrangedMinutes((Integer)doc.get((Object)"arranged_minutes"));
        return classRoom;
    }

    private Date getDateFromSolr(Date date) {
        if (date == null) {
            return null;
        }
        Long time = date.getTime();
        int timeDiff = TimeZone.getDefault().getRawOffset() - TimeZone.getTimeZone("GMT").getRawOffset();
        Long time1 = time - (long)timeDiff;
        date = new Date(time1);
        return date;
    }
}

