/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.dto;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgTeacherDocument {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherDocument.class);
    private String id;
    private Long orgId;
    private Long orgTeacherId;
    private Long teacherUserId;
    private Long createTime;
    private Long pauseTime;
    private String name;
    private String mobile = "";
    private Integer useStatus = 0;
    private Long avatarStorageId = -1L;
    private String dataMonth;
    private Integer hasSignupStudentCount = 0;
    private Integer arrangeStudentCount = 0;
    private long scoreNum = 0L;
    private Integer arrangeClassTime = 0;
    private Integer finishedClassTime = 0;
    private static final String ID_FORMAT = "t_%s_%s";

    public static OrgTeacherDocument newInstance(Long userId, String dataMonth) {
        if (GenericsUtils.isNullOrEmpty((Object)dataMonth)) {
            dataMonth = null;
        }
        OrgTeacherDocument newInstance = OrgTeacherDocument.newInstance();
        newInstance.setId(OrgTeacherDocument.createId(userId, dataMonth));
        newInstance.setTeacherUserId(userId);
        newInstance.setDataMonth(dataMonth);
        return newInstance;
    }

    public static String createId(Long userId, String dataMonth) {
        return String.format(ID_FORMAT, userId, dataMonth);
    }

    private static OrgTeacherDocument newInstance() {
        return new OrgTeacherDocument();
    }

    public static List<OrgTeacherDocument> buidOrgTeacherDocumentFromMap(List<Map<String, Object>> listByQuery) {
        ArrayList retDocuments = Lists.newArrayList();
        for (Map<String, Object> valueMap : listByQuery) {
            OrgTeacherDocument bean = new OrgTeacherDocument();
            try {
                BeanUtils.populate((Object)bean, valueMap);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.info("can not populate bean from map:{} ", valueMap);
            }
            retDocuments.add(bean);
            bean.setCreateTime(Long.parseLong(((Map)valueMap.get("createTime")).get("$numberLong").toString()));
        }
        return retDocuments;
    }

    public String getId() {
        return this.id;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getOrgTeacherId() {
        return this.orgTeacherId;
    }

    public Long getTeacherUserId() {
        return this.teacherUserId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getPauseTime() {
        return this.pauseTime;
    }

    public String getName() {
        return this.name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Integer getUseStatus() {
        return this.useStatus;
    }

    public Long getAvatarStorageId() {
        return this.avatarStorageId;
    }

    public String getDataMonth() {
        return this.dataMonth;
    }

    public Integer getHasSignupStudentCount() {
        return this.hasSignupStudentCount;
    }

    public Integer getArrangeStudentCount() {
        return this.arrangeStudentCount;
    }

    public long getScoreNum() {
        return this.scoreNum;
    }

    public Integer getArrangeClassTime() {
        return this.arrangeClassTime;
    }

    public Integer getFinishedClassTime() {
        return this.finishedClassTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setOrgTeacherId(Long orgTeacherId) {
        this.orgTeacherId = orgTeacherId;
    }

    public void setTeacherUserId(Long teacherUserId) {
        this.teacherUserId = teacherUserId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setPauseTime(Long pauseTime) {
        this.pauseTime = pauseTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setUseStatus(Integer useStatus) {
        this.useStatus = useStatus;
    }

    public void setAvatarStorageId(Long avatarStorageId) {
        this.avatarStorageId = avatarStorageId;
    }

    public void setDataMonth(String dataMonth) {
        this.dataMonth = dataMonth;
    }

    public void setHasSignupStudentCount(Integer hasSignupStudentCount) {
        this.hasSignupStudentCount = hasSignupStudentCount;
    }

    public void setArrangeStudentCount(Integer arrangeStudentCount) {
        this.arrangeStudentCount = arrangeStudentCount;
    }

    public void setScoreNum(long scoreNum) {
        this.scoreNum = scoreNum;
    }

    public void setArrangeClassTime(Integer arrangeClassTime) {
        this.arrangeClassTime = arrangeClassTime;
    }

    public void setFinishedClassTime(Integer finishedClassTime) {
        this.finishedClassTime = finishedClassTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgTeacherDocument)) {
            return false;
        }
        OrgTeacherDocument other = (OrgTeacherDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$orgTeacherId = this.getOrgTeacherId();
        Long other$orgTeacherId = other.getOrgTeacherId();
        if (this$orgTeacherId == null ? other$orgTeacherId != null : !((Object)this$orgTeacherId).equals(other$orgTeacherId)) {
            return false;
        }
        Long this$teacherUserId = this.getTeacherUserId();
        Long other$teacherUserId = other.getTeacherUserId();
        if (this$teacherUserId == null ? other$teacherUserId != null : !((Object)this$teacherUserId).equals(other$teacherUserId)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$pauseTime = this.getPauseTime();
        Long other$pauseTime = other.getPauseTime();
        if (this$pauseTime == null ? other$pauseTime != null : !((Object)this$pauseTime).equals(other$pauseTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        Integer this$useStatus = this.getUseStatus();
        Integer other$useStatus = other.getUseStatus();
        if (this$useStatus == null ? other$useStatus != null : !((Object)this$useStatus).equals(other$useStatus)) {
            return false;
        }
        Long this$avatarStorageId = this.getAvatarStorageId();
        Long other$avatarStorageId = other.getAvatarStorageId();
        if (this$avatarStorageId == null ? other$avatarStorageId != null : !((Object)this$avatarStorageId).equals(other$avatarStorageId)) {
            return false;
        }
        String this$dataMonth = this.getDataMonth();
        String other$dataMonth = other.getDataMonth();
        if (this$dataMonth == null ? other$dataMonth != null : !this$dataMonth.equals(other$dataMonth)) {
            return false;
        }
        Integer this$hasSignupStudentCount = this.getHasSignupStudentCount();
        Integer other$hasSignupStudentCount = other.getHasSignupStudentCount();
        if (this$hasSignupStudentCount == null ? other$hasSignupStudentCount != null : !((Object)this$hasSignupStudentCount).equals(other$hasSignupStudentCount)) {
            return false;
        }
        Integer this$arrangeStudentCount = this.getArrangeStudentCount();
        Integer other$arrangeStudentCount = other.getArrangeStudentCount();
        if (this$arrangeStudentCount == null ? other$arrangeStudentCount != null : !((Object)this$arrangeStudentCount).equals(other$arrangeStudentCount)) {
            return false;
        }
        if (this.getScoreNum() != other.getScoreNum()) {
            return false;
        }
        Integer this$arrangeClassTime = this.getArrangeClassTime();
        Integer other$arrangeClassTime = other.getArrangeClassTime();
        if (this$arrangeClassTime == null ? other$arrangeClassTime != null : !((Object)this$arrangeClassTime).equals(other$arrangeClassTime)) {
            return false;
        }
        Integer this$finishedClassTime = this.getFinishedClassTime();
        Integer other$finishedClassTime = other.getFinishedClassTime();
        return !(this$finishedClassTime == null ? other$finishedClassTime != null : !((Object)this$finishedClassTime).equals(other$finishedClassTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgTeacherDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $orgTeacherId = this.getOrgTeacherId();
        result = result * 59 + ($orgTeacherId == null ? 43 : ((Object)$orgTeacherId).hashCode());
        Long $teacherUserId = this.getTeacherUserId();
        result = result * 59 + ($teacherUserId == null ? 43 : ((Object)$teacherUserId).hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $pauseTime = this.getPauseTime();
        result = result * 59 + ($pauseTime == null ? 43 : ((Object)$pauseTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        Integer $useStatus = this.getUseStatus();
        result = result * 59 + ($useStatus == null ? 43 : ((Object)$useStatus).hashCode());
        Long $avatarStorageId = this.getAvatarStorageId();
        result = result * 59 + ($avatarStorageId == null ? 43 : ((Object)$avatarStorageId).hashCode());
        String $dataMonth = this.getDataMonth();
        result = result * 59 + ($dataMonth == null ? 43 : $dataMonth.hashCode());
        Integer $hasSignupStudentCount = this.getHasSignupStudentCount();
        result = result * 59 + ($hasSignupStudentCount == null ? 43 : ((Object)$hasSignupStudentCount).hashCode());
        Integer $arrangeStudentCount = this.getArrangeStudentCount();
        result = result * 59 + ($arrangeStudentCount == null ? 43 : ((Object)$arrangeStudentCount).hashCode());
        long $scoreNum = this.getScoreNum();
        result = result * 59 + (int)($scoreNum >>> 32 ^ $scoreNum);
        Integer $arrangeClassTime = this.getArrangeClassTime();
        result = result * 59 + ($arrangeClassTime == null ? 43 : ((Object)$arrangeClassTime).hashCode());
        Integer $finishedClassTime = this.getFinishedClassTime();
        result = result * 59 + ($finishedClassTime == null ? 43 : ((Object)$finishedClassTime).hashCode());
        return result;
    }

    public String toString() {
        return "OrgTeacherDocument(id=" + this.getId() + ", orgId=" + this.getOrgId() + ", orgTeacherId=" + this.getOrgTeacherId() + ", teacherUserId=" + this.getTeacherUserId() + ", createTime=" + this.getCreateTime() + ", pauseTime=" + this.getPauseTime() + ", name=" + this.getName() + ", mobile=" + this.getMobile() + ", useStatus=" + this.getUseStatus() + ", avatarStorageId=" + this.getAvatarStorageId() + ", dataMonth=" + this.getDataMonth() + ", hasSignupStudentCount=" + this.getHasSignupStudentCount() + ", arrangeStudentCount=" + this.getArrangeStudentCount() + ", scoreNum=" + this.getScoreNum() + ", arrangeClassTime=" + this.getArrangeClassTime() + ", finishedClassTime=" + this.getFinishedClassTime() + ")";
    }
}

