package com.baijia.tianxiao.dal.solr.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.baijia.tianxiao.util.GenericsUtils;

/**
 * Created by liuxp on 16/4/28.
 */
public class SolrUtil {
    public static class QueryItem {
        String field;
        Object val;
        Boolean equal;

        public QueryItem(String field, Object val, boolean equal) {
            this.field = field;
            this.val = val;
            this.equal = equal;
        }

        public QueryItem(String field, Object val) {
            this.field = field;
            this.val = val;
            this.equal = true;
        }
    }

    public static enum RangeType {
        INCLUDE_BOTTOM_EXCLUDE_TOP('[', '}'), INCLUDE_BOTTOM_INCLUDE_TOP('[', ']'), EXCLUDE_BOTTOM_EXCLUDE_TOP('{',
            '}'), EXCLUDE_BOTTOM_INCLUDE_TOP('{', ']');
        private char leftBracket;
        private char rightBracket;

        private RangeType(char left, char right) {
            leftBracket = left;
            rightBracket = right;
        }

        public char getLeft() {
            return leftBracket;
        }

        public char getRight() {
            return rightBracket;
        }
    }

    /**
     * 不存在A
     */
    public static String exclude(String field) {
        if (StringUtils.isBlank(field)) {
            throw new RuntimeException("Unexcept param:" + field);
        }
        return String.format("-%s:*", field);
    }

    /**
     * 示例：A=a
     */
    public static String equal(String field, Object obj) {
        if (StringUtils.isBlank(field) || obj == null) {
            throw new RuntimeException("Unexcept param:" + field + ", value:" + obj);
        }
        return String.format("%s:%s", field, obj.toString().replaceAll("\\-", "\\\\-"));
    }

    /**
     * 示例：A!=a
     */
    public static String notEqual(String field, Object obj) {
        if (StringUtils.isBlank(field) || obj == null) {
            throw new RuntimeException("Unexcept param:" + field + ", value:" + obj);
        }
        return String.format("-%s:%s", field, obj.toString().replaceAll("\\-", "\\\\-"));
    }

    /**
     * 存在A
     */
    public static String include(String field) {
        if (StringUtils.isBlank(field)) {
            throw new RuntimeException("Unexcept param:" + field);
        }
        return String.format("+%s:*", field);
    }

    /**
     * 示例：a<=A<b 开闭由rangType控制
     */
    public static String range(String field, RangeType type, Object bottom, Object top) {
        if (StringUtils.isBlank(field) || bottom == null || top == null || type == null) {
            throw new RuntimeException("Unexcept param:" + field + ", bottom:" + bottom + ", top:" + top);
        }

        return String.format("%s:%c %s TO %s %c", field, type.getLeft(), bottom.toString().replaceAll("\\-", "\\\\-"),
            top.toString().replaceAll("\\-", "\\\\-"), type.getRight());
    }

    /**
     * 示例：!(a<=A<b) 开闭由rangType控制
     */
    public static String notRange(String field, RangeType type, Object bottom, Object top) {
        if (StringUtils.isBlank(field) || bottom == null || top == null || type == null) {
            throw new RuntimeException("Unexcept param:" + field + ", bottom:" + bottom + ", top:" + top);
        }

        return String.format("-%s:%c %s TO %s %c", field, type.getLeft(), bottom.toString().replaceAll("\\-", "\\\\-"),
            top.toString().replaceAll("\\-", "\\\\-"), type.getRight());
    }

    /**
     * A存在或A不存在或A为任意值
     */
    public static String any(String field) {
        if (StringUtils.isBlank(field)) {
            throw new RuntimeException("Unexcept param:" + field);
        }
        return String.format("%s:*", field);
    }

    /**
     * 示例：A=a OR A=b OR A=c
     */
    public static String or(String field, Collection<?> vals) {
        if (StringUtils.isBlank(field) || vals == null || vals.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder(field).append(":( ");
        for (Object val : vals) {
            sb.append(val.toString().replaceAll("\\-", "\\\\-")).append(" OR ");
        }
        sb.delete(sb.length() - 3, sb.length());
        sb.append(")");
        return sb.toString();
    }

    /**
     * 万能的OR
     */
    public static String or(List<List<QueryItem>> queryItemGroup) {
        if (CollectionUtils.isEmpty(queryItemGroup)) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (List<QueryItem> queryItems : queryItemGroup) {
            if (CollectionUtils.isEmpty(queryItems)) {
                throw new RuntimeException("Unexcept params");
            }
            sb.append("(");
            for (QueryItem item : queryItems) {
                if (item.equal) {
                    sb.append(String.format("%s:%s", item.field, item.val.toString().replaceAll("\\-", "\\\\-")));
                } else {
                    sb.append(String.format("-%s:%s", item.field, item.val.toString().replaceAll("\\-", "\\\\-")));
                }
                sb.append(" AND ");
            }
            sb.delete(sb.length() - 4, sb.length());
            sb.append(")");
            sb.append(" OR ");
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    /**
     * 示例：A!=a OR B!=b OR C!=c
     */
    public static String notOr(Map<String, ?> valByField) {
        if (valByField == null || valByField.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : valByField.keySet()) {
            sb.append(String.format("-%s:%s OR ", field, valByField.get(field)));
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    public static String or(Map<String, ?> valByField) {
        if (valByField == null || valByField.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : valByField.keySet()) {
            sb.append(String.format("%s:%s OR ", field, valByField.get(field)));
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    /**
     * 示例：m1:0 AND m2:0 AND m3:0 AND m0:0
     */
    public static String notAnd(Map<String, ?> valByField) {
        return "-(" + and(valByField) + ")";
    }

    /**
     * 示例：-(m1:0 AND m2:0 AND m3:0 AND m0:0 )
     */
    public static String and(Map<String, ?> valByField) {
        if (valByField == null || valByField.isEmpty()) {
            throw new RuntimeException("Unexcept params");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : valByField.keySet()) {
            sb.append(String.format("%s:%s AND ", field, valByField.get(field)));
        }
        sb.delete(sb.length() - 4, sb.length());
        return sb.toString();
    }

    public static void main(String[] args) {
        List<QueryItem> items = new ArrayList<>();
        items.add(new QueryItem("a", 9));
        items.add(new QueryItem("b", 19));
        items.add(new QueryItem("c", 29, false));
        List<List<QueryItem>> result = new ArrayList<List<QueryItem>>();
        result.add(items);
        items = new ArrayList<QueryItem>();
        items.add(new QueryItem("aa", 229, false));
        items.add(new QueryItem("bb", 129));
        items.add(new QueryItem("cc", 2911, false));
        result.add(items);
        System.out.println(or(result));
        Map<String, Integer> valMap = new HashMap<String, Integer>();
        valMap.put("m0", 0);
        valMap.put("m1", 0);
        valMap.put("m2", 0);
        valMap.put("m3", 0);
        System.out.println(and(valMap));
        System.out.println(notAnd(valMap));
    }

    private static String LIKE_FORMAT = "%s %s:*%s*";

    /**
     * @param string
     * @param searchKey
     * @param true1
     * @return
     */
    public static String like(String field, String searchKey, Boolean...isNeedContect) {
        String left = "";
        if (GenericsUtils.notNullAndEmpty(isNeedContect)) {
            boolean isNeedContect_ = isNeedContect[0];
            if (isNeedContect_) {
                left = " AND ";
            } else {
                left = " OR ";
            }
        }
        return String.format(LIKE_FORMAT, left, field, searchKey);
    }
}
