package com.baijia.tianxiao.dal.solr.query;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.solr.client.solrj.SolrServerException;

import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.dto.StudentQueryParam;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.po.StudentStatusStatistics;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.TwoTuple;

/**
 * Created by liuxp on 16/4/28.
 */
public interface CrmStudentQuery extends SolrService {
    List<StudentStatusStatistics> queryCountByStatus(long orgId,boolean needDataAuthority,Collection<Long> studentIds, Integer cascadeId);

    List<StudentDto> queryStudent(StudentQueryParam param, PageDto pageDto);

    public Set<Long> queryUserIdsByTag(String tag, Long orgId);

    public StudentDto queryStudentById(Long userId, Long orgId);

    public List<StudentClassHour> queryStudentClassHourList(Long userId, Long orgId);

    public List<StudentClassHour> queryStudentClassCount(Long orgId,Collection<Long> userIds,PageDto pageDto);

    public Set<Long> queryCourseStudentUserIds(Collection<Long> courseIds, Long orgId);
    
    public void insertNewRow(Map<String, String> rs) throws SolrServerException, IOException;
    
    public void updateOldRow(Map<String, String> rs) throws SolrServerException, IOException;

    public void deleteOldRow(Map<String, String> rs) throws SolrServerException, IOException;

    /**
     * @param studentDtos
     * @param orgId
     * @param ownCourseIds
     */
    void setClassInfo(List<StudentDto> studentDtos, Long orgId, Set<Long> ownCourseIds);

    /**
     * @param userIds
     * @param orgId
     * @return
     */
    TwoTuple<Map<String, StudentClass>, Map<String, StudentClassHour>> findStudentClassAndStudentClassHour(
        Collection<Long> userIds, Long orgId);
}
