
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.solr.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 26, 2016
 * @Desc this guy is too lazy, nothing left.
 */
public enum PCStudentOrderEnum {

    NAME_ORDER("name", "pinyin"), MOBILE_ORDER("mobile", "mobile"), MOBILE_CREATE_ORDER("createTime",
        "create_time"), PARENT_NAME_ORDER("parentName", "parent_name"), GENDER_ORDER("gender",
            "gender"), PARENT_MOBILE_ORDER("parentMobile", "parent_mobile"), NEXT_REMAIND_TIME_ORDER("nextRemindTime",
                "next_remind_time"), WEIXIN_ORDER("weixin", "weixin"), SCHOOL_ORDER("school", "school", false), // solr
    BIRTHDAY_ORDER("birthdayStr", "birthday", false), // solr还没加上
    DEGREE_CLASS_ORDER("degreeClass", "degree_class", false), // solr 还没加上
    ADDRESS_ORDER("address", "address", false), // solr 还没加上
    QQ_ORDER("qq", "qq", false), // solr 还没加上
    MAIL_ORDER("mail", "mail", false), // solr 还没加上
    ;

    public String orderName;
    public String matchField;
    public boolean canUse;

    private PCStudentOrderEnum(String orderName, String matchField, boolean canUse) {
        this.orderName = orderName;
        this.matchField = matchField;
        this.canUse = canUse;
    }

    private PCStudentOrderEnum(String orderName, String matchField) {
        this(orderName, matchField, true);
    }

    public static final Map<String, PCStudentOrderEnum> enums = new HashMap<>();

    static {
        for (PCStudentOrderEnum pcEnum : PCStudentOrderEnum.values()) {
            enums.put(pcEnum.orderName, pcEnum);
        }
    }

    /**
     * 默认根据pinyin字段进行排序
     * 
     * @param key
     * @return
     */
    public static String find(String key) {
        PCStudentOrderEnum mapperField = enums.get(key);
        if (mapperField == null || !mapperField.canUse) {
            return NAME_ORDER.matchField;
        } else {
            return mapperField.matchField;
        }
    }

}
