/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.tianxiao.dal.solr.constant.SolrConfig;
import com.baijia.tianxiao.dal.solr.query.impl.SolrAbstractServiceImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCommit
extends SolrAbstractServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(SolrCommit.class);

    public void commitSolr() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
            String ip = addr.getHostAddress();
            log.info("[Databus] allowed ip={},localhost ip={}", (Object)SolrConfig.ALLOW_IP, (Object)ip);
            if ("0.0.0.0".equals(SolrConfig.ALLOW_IP) || StringUtils.isNotBlank((CharSequence)ip) && ip.equals(SolrConfig.ALLOW_IP)) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (SolrCommit.this.getSolr() == null) {
                            log.debug("[Solr] No Solr config-------");
                            return;
                        }
                        while (true) {
                            log.debug("[Solr] update index-------");
                            try {
                                SolrCommit.this.getSolr().commit("crm_students", true, true, true);
                                SolrCommit.this.getSolr().commit("crm_consultor", true, true, true);
                                log.info("[Solr] update finish-------");
                                Thread.sleep(5000L);
                                continue;
                            }
                            catch (SolrServerException e) {
                                log.error("[Solr] SolrServerException ", (Throwable)e);
                                continue;
                            }
                            catch (IOException e) {
                                log.error("[Solr] IOException ", (Throwable)e);
                                continue;
                            }
                            catch (InterruptedException e) {
                                log.error("[Solr] InterruptedException ", (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                }).start();
            } else {
                log.info("[Solr] This ip is not allowed.ip={}", (Object)ip);
            }
        }
        catch (UnknownHostException e) {
            log.error("[Solr] UnknownHostException", (Throwable)e);
        }
    }
}

