/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.enums;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PCConsultOrderEnum {
    MOBILE("mobile", "mobile"),
    NAME("name", "pinyin", "name"),
    MAIL("mail", "mail"),
    QQ("qq", "qq"),
    DEGREECLASS("degreeClass", "degree_class"),
    ADDRESS("address", "address"),
    RELATIVES("relatives", "relatives"),
    BIRTHDAY("birthday", "birthday"),
    SCHOOL("school", "school"),
    INTENSION_LEVEL("intensionLevel", "intension_level"),
    CONSULT_SOURCE("consultSource", "consult_source"),
    PARENT_MOBILE("parentMobile", "parent_mobile"),
    PARENT_NAME("parentName", "parent_name"),
    CONSULT_STATUS("consultStatus", "consult_status"),
    SEX("sex", "sex"),
    NEXT_REMIND_TIME("nextRemindTime", "next_remind_time"),
    TAG("tag", "tag", "tag"),
    EMPTY("", "", "");

    private static final Logger log;
    public String orderName;
    public String matchField;
    public String queryField;
    private static Map<String, PCConsultOrderEnum> sourceMap;
    private static String PINYIN;

    private PCConsultOrderEnum(String orderName, String matchField) {
        this(orderName, matchField, null);
    }

    private PCConsultOrderEnum(String orderName, String matchField, String queryField) {
        this.orderName = orderName;
        this.matchField = matchField;
        this.queryField = queryField;
    }

    public static String getMatchField(String orderName) {
        return PCConsultOrderEnum.getMatchFieldWithDefault(orderName, PINYIN, false);
    }

    public static String getMatchFieldWithDefault(String orderName, String defaultField, boolean isQuery) {
        String ret = null;
        PCConsultOrderEnum consultEnum = null;
        if (GenericsUtils.notNullAndEmpty((Object)orderName)) {
            consultEnum = sourceMap.get(orderName);
        }
        if (GenericsUtils.isNullOrEmpty(consultEnum)) {
            consultEnum = EMPTY;
        }
        if (consultEnum != null) {
            ret = isQuery && GenericsUtils.notNullAndEmpty((Object)consultEnum.queryField) ? consultEnum.queryField : consultEnum.matchField;
        }
        if (GenericsUtils.isNullOrEmpty(ret)) {
            ret = defaultField;
        }
        log.debug("sortName:{} ,and defaultField:{} , find matchField:{}", new Object[]{orderName, defaultField, ret});
        return ret;
    }

    public static void main(String[] args) {
        String matchField2 = PCConsultOrderEnum.getMatchField("degreeClass");
        System.out.println(matchField2);
    }

    static {
        log = LoggerFactory.getLogger(PCConsultOrderEnum.class);
        sourceMap = Maps.newHashMap();
        for (PCConsultOrderEnum consultEnum : PCConsultOrderEnum.values()) {
            sourceMap.put(consultEnum.orderName, consultEnum);
        }
        PINYIN = "pinyin";
    }
}

