/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.dto.StudentQueryParam;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.OpType;
import com.baijia.tianxiao.dal.solr.enums.PCStudentOrderEnum;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.exceptions.SolrException;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.po.StudentStatusStatistics;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.solr.query.impl.SolrAbstractServiceImpl;
import com.baijia.tianxiao.dal.solr.utils.DateUtil;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CrmStudentQueryImpl
extends SolrAbstractServiceImpl
implements CrmStudentQuery {
    private static final Logger log = LoggerFactory.getLogger(CrmStudentQueryImpl.class);
    private static final int MAX_QUERY_LIMIT = 1000;
    private static final String SOLR_DATE_FORMATTER = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @Override
    public List<StudentStatusStatistics> queryCountByStatus(long orgId, boolean needDataAuthority, Collection<Long> studentIds, Integer cascadeId) {
        long begin = System.currentTimeMillis();
        List<StudentStatusStatistics> result = StudentStatusStatistics.getDefaut();
        HashMap<Integer, StudentStatusStatistics> map = new HashMap<Integer, StudentStatusStatistics>();
        for (StudentStatusStatistics statistics : result) {
            map.put(statistics.getStatus(), statistics);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("id:s_* AND del_status:0 AND org_id:").append(orgId);
        if (needDataAuthority) {
            sb.append(" AND (");
            if (studentIds != null && studentIds.size() > 0) {
                sb.append(SolrUtil.or("user_id", studentIds));
                sb.append(" OR ");
            }
            sb.append(" add_cascade_id:").append(cascadeId);
            sb.append(")");
        }
        SolrQuery query = new SolrQuery();
        query.setFacet(true);
        query.setRows(Integer.valueOf(0));
        query.addFacetField(new String[]{"lesson_status"});
        log.info("[Solr] query param:" + sb.toString());
        query.setQuery(sb.toString());
        try {
            QueryResponse response = this.getSolr().query("crm_students", (SolrParams)query, SolrRequest.METHOD.POST);
            List facets = response.getFacetFields();
            for (FacetField facet : facets) {
                if (!facet.getName().equals("lesson_status")) continue;
                List counts = facet.getValues();
                for (FacetField.Count count : counts) {
                    StudentStatusStatistics statistics = (StudentStatusStatistics)map.get(Integer.parseInt(count.getName()));
                    log.info("[Solr] countName=" + count.getName());
                    if (statistics == null) continue;
                    StudentLessonStatus studentStatus = StudentLessonStatus.getStatus(Integer.parseInt(count.getName()));
                    statistics.setName(studentStatus.getName());
                    statistics.setStatus(studentStatus.getStatus());
                    statistics.setNumber(count.getCount());
                }
            }
            log.info("[Solr] Query status cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)orgId);
        }
        catch (SolrServerException e) {
            log.error("[Solr] SolrServerException ", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        catch (IOException e) {
            log.error("[Solr] IOException ", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        StudentStatusStatistics studying = (StudentStatusStatistics)map.get(StudentLessonStatus.STUDYING.getStatus());
        StudentStatusStatistics toCharge = (StudentStatusStatistics)map.get(StudentLessonStatus.TO_CHARGE.getStatus());
        StudentStatusStatistics past = (StudentStatusStatistics)map.get(StudentLessonStatus.PAST.getStatus());
        studying.setNumber(studying.getNumber() + toCharge.getNumber());
        StudentStatusStatistics all = (StudentStatusStatistics)map.get(StudentLessonStatus.ALL.getStatus());
        all.setName(StudentLessonStatus.ALL.getName());
        all.setStatus(StudentLessonStatus.ALL.getStatus());
        all.setNumber(studying.getNumber() + past.getNumber());
        log.info("[Solr] Query status cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)orgId);
        return result;
    }

    @Override
    public List<StudentClassHour> queryStudentClassCount(Long orgId, PageDto pageDto) {
        ArrayList<StudentClassHour> ret = new ArrayList<StudentClassHour>();
        StringBuilder sb = new StringBuilder();
        sb.append("id:stu_lesson_* AND org_id:" + orgId);
        SolrQuery query = new SolrQuery();
        log.info("[Solr] query param:" + sb.toString());
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int limit = pageDto.getPageSize();
        query.addSort("student_id", SolrQuery.ORDER.desc);
        query.setStart(Integer.valueOf(start));
        query.setRows(Integer.valueOf(limit));
        query.setQuery(sb.toString());
        QueryResponse response = null;
        try {
            response = this.getSolr().query("crm_students", (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList list = response.getResults();
            for (SolrDocument document : list) {
                StudentClassHour classHour = this.buildStudentClassHour(document);
                ret.add(classHour);
            }
        }
        catch (SolrServerException e) {
            log.error("[Solr] SolrServerException ", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        catch (IOException e) {
            log.error("[Solr] IOException ", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        return ret;
    }

    @Override
    public Set<Long> queryUserIdsByTag(String tag, Long orgId) {
        HashSet<Long> userIds = new HashSet<Long>();
        if (tag == null) {
            return userIds;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("id:t_* AND ").append(" org_id:" + orgId).append(" AND content:*" + tag + "*");
        SolrQuery query = new SolrQuery();
        log.info("[Solr] query tag param:" + sb.toString());
        query.setQuery(sb.toString());
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        QueryResponse response = null;
        try {
            response = this.getSolr().query("crm_students", (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList list = response.getResults();
            log.info("[Solr] query tag result:" + list.getNumFound());
            for (SolrDocument doc : list) {
                Long userId = (Long)doc.get((Object)"user_id");
                userIds.add(userId);
            }
        }
        catch (SolrServerException e) {
            log.error("[Solr] SolrServerException ", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        catch (IOException e) {
            log.error("[Solr] IOException ", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        return userIds;
    }

    private Set<Long> queryUserIdsByEnrollTime(Date startTime, Date endTime, long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:e_* AND del_status:0 AND ").append(" org_id:" + orgId);
        if (startTime != null && endTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(SOLR_DATE_FORMATTER);
            sb.append(" AND enroll_time:[" + sdf.format(startTime) + " TO " + sdf.format(endTime) + "}");
        }
        HashSet<Long> userIds = new HashSet<Long>();
        SolrDocumentList list = this.getDocumentList("crm_students", sb.toString());
        log.info("[Solr] query enroll result:" + list.getNumFound());
        for (SolrDocument doc : list) {
            Long userId = (Long)doc.get((Object)"user_id");
            userIds.add(userId);
        }
        return userIds;
    }

    @Override
    public List<StudentDto> queryStudent(StudentQueryParam param, PageDto pageDto) {
        long begin = System.currentTimeMillis();
        log.info("QueryParam=" + param.toString());
        ArrayList<StudentDto> retList = new ArrayList<StudentDto>();
        Set<Long> querySet = param.getStudentIds();
        Set<Long> ownCourseIds = null;
        StringBuilder sb = new StringBuilder();
        sb.append("id:s_* AND del_status:0 AND org_id:" + param.getOrgId());
        SolrQuery query = new SolrQuery();
        try {
            SolrQuery.ORDER order;
            Set<Long> ids;
            if (param.getStatus() != null && param.getStatus() != StudentLessonStatus.ALL) {
                if (StudentLessonStatus.STUDYING == param.getStatus()) {
                    sb.append(" AND (lesson_status:").append(StudentLessonStatus.STUDYING.getStatus()).append(" OR lesson_status:").append(StudentLessonStatus.TO_CHARGE.getStatus()).append(")");
                } else {
                    sb.append(" AND lesson_status:").append(param.getStatus().getStatus());
                }
            }
            TimeRange range = null;
            Set<Long> enrollUserIds = null;
            if (param.getEnrollTime() != null) {
                range = param.getEnrollTime().timeRange();
                enrollUserIds = this.queryUserIdsByEnrollTime(range.getStartTime(), range.getEndTime(), param.getOrgId());
            }
            if (param.getOpType() != null && param.getOpType() == OpType.ENROLL) {
                enrollUserIds = this.queryUserIdsByEnrollTime(com.baijia.tianxiao.util.date.DateUtil.getStartOfDay((Date)com.baijia.tianxiao.util.date.DateUtil.getOffSetDate((Date)new Date(), (int)-6)), com.baijia.tianxiao.util.date.DateUtil.getStartOfDay((Date)com.baijia.tianxiao.util.date.DateUtil.getOffSetDate((Date)new Date(), (int)1)), param.getOrgId());
            }
            if (enrollUserIds != null) {
                if (!querySet.isEmpty()) {
                    querySet.retainAll(enrollUserIds);
                } else {
                    querySet = new LinkedHashSet<Long>();
                    querySet.addAll(enrollUserIds);
                }
                if (querySet.isEmpty()) {
                    return Collections.emptyList();
                }
            }
            log.info("[Solr] querySet=" + querySet + ";StudentIds=" + param.getStudentIds());
            if (param.getLessonStatus() != null) {
                if (param.getLessonStatus() == 1) {
                    query.setFilterQueries(new String[]{"{!join from=student_id to=user_id}id:stu_lesson_*"});
                } else {
                    query.setFilterQueries(new String[]{"-{!join from=student_id to=user_id}id:stu_lesson_*"});
                }
            }
            if (param.getLeftMinClassHour() != null || param.getLeftMaxClassHour() != null) {
                if (param.getLessonStatus() != null && param.getLessonStatus() == 2) {
                    return Collections.emptyList();
                }
                StringBuilder fqSb = new StringBuilder();
                fqSb.append("{!join from=student_id to=user_id v='left_count:[");
                if (param.getLeftMinClassHour() != null) {
                    fqSb.append(param.getLeftMinClassHour());
                } else {
                    fqSb.append("*");
                }
                fqSb.append(" TO ");
                if (param.getLeftMaxClassHour() != null) {
                    fqSb.append(param.getLeftMaxClassHour());
                } else {
                    fqSb.append("*");
                }
                fqSb.append("]'}id:stu_lesson_*");
                log.info("[Solr] fq = {}", (Object)fqSb.toString());
                query.setFilterQueries(new String[]{fqSb.toString()});
            }
            SimpleDateFormat sdf = new SimpleDateFormat(SOLR_DATE_FORMATTER);
            if (param.getOpType() != null) {
                Date start = null;
                Date end = null;
                switch (param.getOpType()) {
                    case FOLLOW: {
                        start = com.baijia.tianxiao.util.date.DateUtil.getStartOfDay((Date)new Date());
                        end = com.baijia.tianxiao.util.date.DateUtil.getEndOfDay((Date)com.baijia.tianxiao.util.date.DateUtil.getOffSetDate((Date)start, (int)6));
                        sb.append(" AND ");
                        sb.append("next_remind_time:");
                        sb.append("[" + sdf.format(start) + " TO " + sdf.format(end) + "]");
                        break;
                    }
                    case CREATE: {
                        end = com.baijia.tianxiao.util.date.DateUtil.getEndOfDay((Date)new Date());
                        start = com.baijia.tianxiao.util.date.DateUtil.getStartOfDay((Date)com.baijia.tianxiao.util.date.DateUtil.getOffSetDate((Date)new Date(), (int)-6));
                        sb.append(" AND ");
                        sb.append("create_time:");
                        sb.append("[" + sdf.format(start) + " TO " + sdf.format(end) + "]");
                        break;
                    }
                    default: {
                        log.info("[Solr] OPType=" + (Object)((Object)param.getOpType()));
                    }
                }
            }
            if (param.getCreateTime() != null) {
                range = param.getCreateTime().timeRange();
                sb.append(" AND ");
                sb.append("create_time:[" + sdf.format(range.getStartTime()) + " TO " + sdf.format(range.getEndTime()) + "}");
            }
            if (param.getFollowTime() != null) {
                range = param.getFollowTime().timeRange();
                sb.append(" AND ");
                sb.append("next_remind_time:[" + sdf.format(range.getStartTime()) + " TO " + sdf.format(range.getEndTime()) + "}");
            }
            if (param.getGender() != null) {
                sb.append(" AND ").append("gender:").append(param.getGender());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getSearchKey())) {
                sb.append(" AND (mobile:*").append(param.getSearchKey()).append("* OR name:*").append(param.getSearchKey()).append("* OR pinyin:*").append(param.getSearchKey()).append("* OR parent_mobile:*").append(param.getSearchKey()).append("* OR parent_name:*").append(param.getSearchKey()).append("*");
                ids = this.queryUserIdsByTag(param.getSearchKey(), param.getOrgId());
                if (ids != null && ids.size() > 0) {
                    sb.append(" OR ").append(SolrUtil.or("user_id", ids));
                }
                sb.append(" )");
            }
            if (StringUtils.isNotBlank((CharSequence)param.getQueryStr())) {
                if (param.getQueryStr().equals("mobile")) {
                    sb.append(" AND mobile:*").append(param.getQueryValue()).append("*");
                }
                if (param.getQueryStr().equals("name")) {
                    sb.append(" AND name:*").append(param.getQueryValue()).append("*");
                }
                if (param.getQueryStr().equals("parentName")) {
                    sb.append(" AND parent_name:*").append(param.getQueryValue()).append("*");
                }
                if (param.getQueryStr().equals("parentMobile")) {
                    sb.append(" AND parent_mobile:*").append(param.getQueryValue()).append("*");
                }
                if (param.getQueryStr().equals("tag") && (ids = this.queryUserIdsByTag(param.getQueryValue(), param.getOrgId())) != null && ids.size() > 0) {
                    sb.append(" AND ").append(SolrUtil.or("user_id", ids));
                }
            }
            int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            int limit = pageDto.getPageSize();
            log.info("[Solr] QueryParam=" + query.toString() + "Start=" + start + ";limit=" + limit);
            query.setStart(Integer.valueOf(start));
            query.setRows(Integer.valueOf(limit));
            SolrQuery.ORDER oRDER = order = param.getOrderType() == 0 ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
            if (GenericsUtils.notNullAndEmpty((Object)param.getOrderName())) {
                query.addSort(PCStudentOrderEnum.find(param.getOrderName()), order);
            } else {
                query.addSort("pinyin", SolrQuery.ORDER.asc);
            }
            String queryStr = sb.toString();
            long total = 0L;
            log.info("[Solr] querySet=" + querySet);
            if (querySet != null && querySet.size() > 0 && querySet.size() > 1000) {
                ArrayList<Long> list = new ArrayList<Long>(querySet.size());
                list.addAll(querySet);
                int i = 0;
                while (i * 1000 < querySet.size()) {
                    int from = i * 1000;
                    int to = Math.min((i + 1) * 1000, querySet.size());
                    query.setStart(Integer.valueOf(0));
                    query.setRows(Integer.valueOf(1000));
                    List subList = list.subList(from, to);
                    String str = SolrUtil.or("user_id", subList);
                    String executeQueryStr = queryStr + " AND " + str;
                    query.setQuery(executeQueryStr);
                    log.info("[Solr] student query param= " + executeQueryStr);
                    QueryResponse response = this.getSolr().query("crm_students", (SolrParams)query, SolrRequest.METHOD.POST);
                    SolrDocumentList documentList = response.getResults();
                    Iterator iterator = documentList.iterator();
                    while (iterator.hasNext()) {
                        StudentDto sd = this.buildStudent((SolrDocument)iterator.next());
                        retList.add(sd);
                    }
                    ++i;
                }
                if (start > retList.size()) {
                    return Collections.emptyList();
                }
                total = retList.size();
                Collections.sort(retList, new Comparator<StudentDto>(){

                    @Override
                    public int compare(StudentDto o1, StudentDto o2) {
                        return o1.getPinyin().compareTo(o2.getPinyin());
                    }
                });
                retList = retList.subList(start, Math.min(retList.size(), start + limit));
                pageDto.setCount(Integer.valueOf((int)total));
                log.info("[Solr] Query count=" + total);
                this.setClassInfo(retList, param.getOrgId(), ownCourseIds);
                log.info("[Solr] Query List cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)param.getOrgId());
                return retList;
            }
            if (querySet != null && querySet.size() > 0) {
                log.debug("[Solr] Query querySet={}", querySet);
                queryStr = queryStr + " AND " + SolrUtil.or("user_id", querySet);
            }
            log.info("[Solr] student query param= {},collection={}", (Object)queryStr, (Object)"crm_students");
            query.setQuery(queryStr);
            log.info("[Solr] Query List cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)param.getOrgId());
            QueryResponse response = this.getSolr().query("crm_students", (SolrParams)query, SolrRequest.METHOD.POST);
            log.info("[Solr] Query List cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)param.getOrgId());
            SolrDocumentList documentList = response.getResults();
            Iterator iterator = documentList.iterator();
            while (iterator.hasNext()) {
                retList.add(this.buildStudent((SolrDocument)iterator.next()));
            }
            total = documentList.getNumFound();
            pageDto.setCount(Integer.valueOf((int)total));
            log.info("[Solr] Query count=" + total);
            this.setClassInfo(retList, param.getOrgId(), ownCourseIds);
        }
        catch (Exception e) {
            log.error("[Solr] Exception ", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        log.info("[Solr] Query List cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)param.getOrgId());
        return retList;
    }

    @Override
    public Set<Long> queryCourseStudentUserIds(Collection<Long> courseIds, Long orgId) {
        HashSet<Long> studentIds = new HashSet<Long>();
        if (GenericsUtils.isNullOrEmpty(courseIds)) {
            return studentIds;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("id:e_* AND del_status:0 AND status:0 AND org_id:").append(orgId);
        sb.append(" AND ").append(SolrUtil.or("course_id", courseIds));
        SolrDocumentList documentList = this.getDocumentList("crm_students", sb.toString());
        for (SolrDocument doc : documentList) {
            Long sId = (Long)doc.get((Object)"user_id");
            studentIds.add(sId);
        }
        return studentIds;
    }

    private void setClassInfo(List<StudentDto> studentDtos, Long orgId, Set<Long> ownCourseIds) {
        long begin = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        HashMap<String, StudentClassHour> map = new HashMap<String, StudentClassHour>();
        try {
            if (studentDtos == null || studentDtos.size() < 1) {
                return;
            }
            Map studentIdMap = CollectionUtils.extractMap(studentDtos, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentDto>(){

                public Long extract(StudentDto studentDto) {
                    return studentDto.getUserId();
                }
            });
            sb.append("id:stu_lesson_* AND org_id:" + orgId).append(" AND ").append(SolrUtil.or("student_id", studentIdMap.keySet()));
            if (ownCourseIds != null) {
                sb.append(" AND ").append(SolrUtil.or("course_id", ownCourseIds));
            }
            SolrQuery query = new SolrQuery();
            query.setQuery(sb.toString());
            query.setRows(Integer.valueOf(Integer.MAX_VALUE));
            QueryResponse response = this.getSolr().query("crm_students", (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList list = response.getResults();
            log.info("[Solr] query class param:" + sb.toString());
            log.info("[Solr] query class result:" + list.size());
            HashMap<Long, ArrayList<StudentClassHour>> sscCache = new HashMap<Long, ArrayList<StudentClassHour>>();
            for (SolrDocument document : list) {
                StudentClassHour classHour = this.buildStudentClassHour(document);
                Long userId = classHour.getUserId();
                Long courseId = classHour.getCourseId();
                String key = userId + "_" + courseId;
                if (map.get(key) == null) {
                    map.put(key, classHour);
                } else {
                    classHour = (StudentClassHour)map.get(key);
                }
                ArrayList<StudentClassHour> courseList = (ArrayList<StudentClassHour>)sscCache.get(userId);
                if (courseList == null) {
                    courseList = new ArrayList<StudentClassHour>();
                    sscCache.put(userId, courseList);
                }
                courseList.add(classHour);
            }
            HashMap<Long, StudentClassHour> retMap = new HashMap<Long, StudentClassHour>();
            for (String stuCourseId : map.keySet()) {
                StudentClassHour tempClassHour = (StudentClassHour)map.get(stuCourseId);
                StudentClassHour retClassHour = (StudentClassHour)retMap.get(tempClassHour.getUserId());
                if (retClassHour == null) {
                    retMap.put(tempClassHour.getUserId(), tempClassHour);
                    continue;
                }
                if (tempClassHour.getLeftCount() > 0) {
                    if (retClassHour.getLeftCount() <= 0) {
                        retMap.put(tempClassHour.getUserId(), tempClassHour);
                        continue;
                    }
                    if (retClassHour.getLeftCount() > tempClassHour.getLeftCount()) {
                        retMap.put(tempClassHour.getUserId(), tempClassHour);
                        continue;
                    }
                    if (retClassHour.getLeftCount() != tempClassHour.getLeftCount() || retClassHour.getCourseId() >= tempClassHour.getCourseId()) continue;
                    retMap.put(tempClassHour.getUserId(), tempClassHour);
                    continue;
                }
                if (retClassHour.getLeftCount() > 0 || retClassHour.getCourseId() >= tempClassHour.getCourseId()) continue;
                retMap.put(tempClassHour.getUserId(), tempClassHour);
            }
            for (StudentDto dto : studentDtos) {
                StudentClassHour studentClassHour = (StudentClassHour)retMap.get(dto.getUserId());
                if (studentClassHour == null) continue;
                dto.setLeftClassHour(studentClassHour.getLeftCount());
                dto.setFinishClassHour(studentClassHour.getFinishCount());
                dto.setCourseId(studentClassHour.getCourseId());
            }
        }
        catch (IOException e) {
            log.error("[Solr] IOException ", (Throwable)e);
        }
        catch (SolrServerException e) {
            log.error("[Solr] SolrServerException ", (Throwable)e);
        }
        log.info("[Solr] Query course info cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)orgId);
    }

    private StudentDto buildStudent(SolrDocument doc) {
        StudentDto stu = new StudentDto();
        stu.setName((String)doc.get((Object)"name"));
        stu.setMobile((String)doc.get((Object)"mobile"));
        stu.setWeixin((String)doc.get((Object)"weixin"));
        stu.setStudentId((Long)doc.get((Object)"s_self_id"));
        stu.setUserId((Long)doc.get((Object)"user_id"));
        stu.setPinyin((String)doc.get((Object)"pinyin"));
        return stu;
    }

    private StudentClassHour buildStudentClassHour(SolrDocument doc) {
        Long studentId = (Long)doc.get((Object)"student_id");
        Long courseId = (Long)doc.get((Object)"course_id");
        Long totalCount = (Long)doc.get((Object)"total");
        Long finishCount = (Long)doc.get((Object)"finished");
        totalCount = totalCount == null ? 0L : totalCount;
        finishCount = finishCount == null ? 0L : finishCount;
        StudentClassHour classHour = new StudentClassHour();
        classHour.setUserId(studentId);
        classHour.setCourseId(courseId);
        classHour.setFinishCount(finishCount.intValue());
        classHour.setTotalCount(totalCount.intValue());
        return classHour;
    }

    @Override
    public StudentDto queryStudentById(Long userId, Long orgId) {
        StudentDto dto = null;
        StringBuilder sb = new StringBuilder();
        sb.append("id:s_* AND del_status:0 AND org_id:" + orgId);
        sb.append(" AND user_id:" + userId);
        SolrDocumentList list = this.getDocumentList("crm_students", sb.toString());
        ArrayList<StudentDto> dtos = new ArrayList<StudentDto>();
        for (SolrDocument doc : list) {
            dto = this.buildStudent(doc);
            dtos.add(dto);
        }
        this.setClassInfo(dtos, orgId, null);
        return dto;
    }

    @Override
    public List<StudentClassHour> queryStudentClassHourList(Long userId, Long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:stu_lesson_* AND org_id:" + orgId).append(" AND ").append("student_id:" + userId);
        SolrDocumentList list = this.getDocumentList("crm_students", sb.toString());
        ArrayList<StudentClassHour> ret = new ArrayList<StudentClassHour>();
        for (SolrDocument document : list) {
            StudentClassHour classHour = this.buildStudentClassHour(document);
            ret.add(classHour);
        }
        return ret;
    }

    @Override
    public void updateOldRow(Map<String, String> rs) throws SolrServerException, IOException {
        rs = this.mapKeyToUpper(rs);
        Map<String, Object> insertKeyMap = this.getValueMap(rs);
        log.info("Debug insertKeyMap" + insertKeyMap + "collection:" + "crm_consultor");
        this.update("crm_students", insertKeyMap);
    }

    @Override
    public void deleteOldRow(Map<String, String> rs) throws SolrServerException, IOException {
        rs = this.mapKeyToUpper(rs);
        String key = rs.get("ID");
        String query = "id:c_" + key;
        this.delete("crm_students", query);
    }

    @Override
    public void insertNewRow(Map<String, String> rs) throws SolrServerException, IOException {
        rs = this.mapKeyToUpper(rs);
        Map<String, Object> insertKeyMap = this.getValueMap(rs);
        this.add("crm_students", insertKeyMap);
    }

    private Map<String, Object> getValueMap(Map<String, String> rs) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", "s_" + rs.get("ID"));
        map.put("s_self_id", Long.parseLong(rs.get("ID")));
        map.put("user_id", Long.parseLong(rs.get("USER_ID")));
        map.put("org_id", Long.parseLong(rs.get("ORG_ID")));
        map.put("name", rs.get("STUDENT_NAME"));
        map.put("mobile", rs.get("MOBILE"));
        map.put("weixin", rs.get("WEIXIN"));
        map.put("lesson_status", rs.get("LESSON_STATUS"));
        String pinyin = HanZiPinYinUtils.getLowerCasePinYin((String)rs.get("STUDENT_NAME"));
        if (StringUtils.isNotBlank((CharSequence)pinyin)) {
            char init = pinyin.charAt(0);
            if (init < 'a' || init > 'z') {
                pinyin = "~";
            }
        } else {
            pinyin = "~";
        }
        map.put("pinyin", pinyin);
        if (StringUtils.isNotBlank((CharSequence)rs.get("GENDER"))) {
            map.put("gender", Integer.parseInt(rs.get("GENDER")));
        }
        if (StringUtils.isNotBlank((CharSequence)rs.get("DEL_STATUS"))) {
            map.put("del_status", Integer.parseInt(rs.get("DEL_STATUS")));
        }
        if (StringUtils.isNotBlank((CharSequence)rs.get("AVATAR"))) {
            map.put("avatar", Long.parseLong(rs.get("AVATAR")));
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)rs.get("CREATE_TIME"))) {
                map.put("create_time", DateUtil.getSolrDate(sdf.parse(rs.get("CREATE_TIME"))));
            }
            if (StringUtils.isNotBlank((CharSequence)rs.get("UPDATE_TIME"))) {
                map.put("update_time", DateUtil.getSolrDate(sdf.parse(rs.get("UPDATE_TIME"))));
            }
            if (StringUtils.isNotBlank((CharSequence)rs.get("NEXT_REMIND_TIME"))) {
                map.put("next_remind_time", DateUtil.getSolrDate(sdf.parse(rs.get("NEXT_REMIND_TIME"))));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return map;
    }
}

