/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.tianxiao.dal.solr.constant.SolrConfig;
import com.baijia.tianxiao.dal.solr.exceptions.SolrException;
import com.baijia.tianxiao.dal.solr.query.SolrService;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrAbstractServiceImpl
implements SolrService {
    private static final Logger log = LoggerFactory.getLogger(SolrAbstractServiceImpl.class);
    private volatile CloudSolrClient solrClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudSolrClient getSolr() {
        if (this.solrClient == null && SolrConfig.ZK != null) {
            SolrAbstractServiceImpl solrAbstractServiceImpl = this;
            synchronized (solrAbstractServiceImpl) {
                if (this.solrClient == null && SolrConfig.ZK != null) {
                    this.solrClient = new CloudSolrClient(SolrConfig.ZK);
                }
            }
        }
        return this.solrClient;
    }

    @Override
    public void add(String collection, Map<String, Object> valueByField) throws SolrServerException, IOException {
        if (valueByField == null || valueByField.isEmpty()) {
            return;
        }
        SolrInputDocument inputDocument = new SolrInputDocument();
        for (String field : valueByField.keySet()) {
            inputDocument.addField(field, valueByField.get(field));
        }
        if (log.isDebugEnabled()) {
            log.debug("Try to add document:" + inputDocument);
        }
        this.getSolr().add(collection, inputDocument);
    }

    @Override
    public void update(String collection, Map<String, Object> valueByField) throws SolrServerException, IOException {
        this.add(collection, valueByField);
    }

    @Override
    public void delete(String collection, String key) throws SolrServerException, IOException {
        log.info("[Solr] collection=" + collection + ";key=" + key);
        this.getSolr().deleteByQuery(collection, key);
        this.getSolr().commit(collection);
    }

    @Override
    public SolrDocumentList getDocumentList(String collection, String queryStr) {
        SolrQuery query = new SolrQuery();
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        log.info("[Solr] query param:" + queryStr);
        query.setQuery(queryStr);
        QueryResponse response = null;
        SolrDocumentList list = null;
        try {
            response = this.getSolr().query(collection, (SolrParams)query, SolrRequest.METHOD.POST);
            list = response.getResults();
            log.info("[Solr] query Result:" + list.getNumFound());
        }
        catch (SolrServerException e) {
            log.error("SolrServerException", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
            throw new SolrException((UniverseErrorCode)CrmErrorCode.SOLR_EXCEPTION);
        }
        return list;
    }
}

