/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.enums;

import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Calendar;
import java.util.Date;

public enum TimeType {
    TODAY(1, "\u4eca\u5929"),
    YESTERDAY(2, "\u6628\u5929"),
    THIS_WEEK(3, "\u672c\u5468"),
    LAST_WEEK(4, "\u4e0a\u5468"),
    THIS_MONTH(5, "\u672c\u6708"),
    LAST_MONTH(6, "\u4e0a\u6708"),
    THIS_SEASON(7, "\u672c\u5b63\u5ea6"),
    LAST_SEASON(8, "\u4e0a\u5b63\u5ea6");

    private int code;
    private String desc;

    private TimeType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TimeType getTimeTypeByCode(Integer code) {
        if (code == null || code == 0) {
            return null;
        }
        if (code < 1 || code > 8) {
            return TODAY;
        }
        return TimeType.values()[code - 1];
    }

    public TimeRange timeRange() {
        TimeRange range = new TimeRange();
        Date start = null;
        Date end = null;
        Calendar calendar = Calendar.getInstance();
        switch (this) {
            case YESTERDAY: {
                end = DateUtil.getStartOfDay((Date)new Date());
                calendar.add(5, -1);
                start = DateUtil.getStartOfDay((Date)calendar.getTime());
                break;
            }
            case THIS_WEEK: {
                start = DateUtil.getStartOfDay((Date)this.getMonday(Calendar.getInstance()));
                calendar.setTime(start);
                calendar.add(5, 7);
                end = calendar.getTime();
                break;
            }
            case LAST_WEEK: {
                end = DateUtil.getStartOfDay((Date)this.getMonday(calendar));
                calendar.add(3, -1);
                start = DateUtil.getStartOfDay((Date)this.getMonday(calendar));
                break;
            }
            case THIS_MONTH: {
                start = DateUtil.getFirstDate((Date)new Date());
                calendar.setTime(start);
                calendar.add(2, 1);
                end = calendar.getTime();
                break;
            }
            case LAST_MONTH: {
                end = DateUtil.getFirstDate((Date)new Date());
                calendar = Calendar.getInstance();
                calendar.add(2, -1);
                start = DateUtil.getFirstDate((Date)calendar.getTime());
                break;
            }
            case THIS_SEASON: {
                calendar = Calendar.getInstance();
                int month = this.getSeasonFirstMonth(calendar);
                calendar.set(2, month);
                start = DateUtil.getFirstDate((Date)calendar.getTime());
                calendar.setTime(start);
                calendar.add(2, 3);
                end = calendar.getTime();
                break;
            }
            case LAST_SEASON: {
                int thisMonth = this.getSeasonFirstMonth(calendar);
                calendar.set(2, thisMonth);
                end = DateUtil.getFirstDate((Date)calendar.getTime());
                Calendar lastSeasonCalendar = Calendar.getInstance();
                lastSeasonCalendar.add(2, -3);
                int lastSeasonMonth = this.getSeasonFirstMonth(lastSeasonCalendar);
                lastSeasonCalendar.set(2, lastSeasonMonth);
                start = DateUtil.getFirstDate((Date)lastSeasonCalendar.getTime());
                break;
            }
            default: {
                start = DateUtil.getStartOfDay((Date)calendar.getTime());
                calendar.add(5, 1);
                end = DateUtil.getStartOfDay((Date)calendar.getTime());
            }
        }
        range.setStartTime(start);
        range.setEndTime(end);
        return range;
    }

    private Date getMonday(Calendar cal) {
        int i = cal.get(7);
        if (i == 1) {
            i = 8;
        }
        cal.add(5, -(i - 2));
        return cal.getTime();
    }

    private int getSeasonFirstMonth(Calendar date) {
        int month = date.get(2);
        for (int i = -1; i < 12; i += 3) {
            if (month > i) continue;
            return i - 2;
        }
        return -1;
    }

    public static void main(String[] args) {
        for (TimeType type : TimeType.values()) {
            System.out.println(type.desc + ":" + type.timeRange());
        }
    }
}

