/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.dto.StudentQueryParam;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.OpType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.po.StudentStatusStatistics;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.solr.query.impl.SolrAbstractServiceImpl;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CrmStudentQueryImpl
extends SolrAbstractServiceImpl
implements CrmStudentQuery {
    private static final Logger log = LoggerFactory.getLogger(CrmStudentQueryImpl.class);
    private static final String collection = "crm_student";
    private static int MAX_QUERY_LIMIT = 1000;

    @Override
    public List<StudentStatusStatistics> queryCountByStatus(long orgId, boolean needDataAuthority, Integer cascadeId, Integer orgNumber) {
        ArrayList<StudentStatusStatistics> result = new ArrayList<StudentStatusStatistics>();
        HashSet<Long> studyingStuIds = new HashSet<Long>();
        HashSet<Long> pastStuIds = new HashSet<Long>();
        HashSet<Long> toChargeStuIds = new HashSet<Long>();
        HashSet<Long> leftClassHourUserIds = new HashSet<Long>();
        Set<Long> ownCourseIds = null;
        if (needDataAuthority && GenericsUtils.isNullOrEmpty(ownCourseIds = this.searchCourse(orgId, cascadeId, orgNumber))) {
            log.info("find current account has not any sutdents , and will set a empty collection for filter");
            ownCourseIds = new HashSet<Long>();
        }
        this.queryUserIdsByStatus(studyingStuIds, pastStuIds, toChargeStuIds, leftClassHourUserIds, orgId, null, null, ownCourseIds);
        long total = this.queryAllUserIds(orgId, ownCourseIds).size();
        for (StudentLessonStatus studentStatus : StudentLessonStatus.values()) {
            StudentStatusStatistics statistics = new StudentStatusStatistics();
            statistics.setName(studentStatus.getName());
            statistics.setStatus(studentStatus.getStatus());
            switch (studentStatus) {
                case ALL: {
                    statistics.setNumber(total);
                    break;
                }
                case STUDYING: {
                    statistics.setNumber(studyingStuIds.size());
                    break;
                }
                case PAST: {
                    statistics.setNumber(pastStuIds.size());
                    break;
                }
                case TO_CHARGE: {
                    statistics.setNumber(toChargeStuIds.size());
                    break;
                }
                default: {
                    statistics.setNumber(0L);
                }
            }
            result.add(statistics);
        }
        return result;
    }

    private void queryUserIdsByStatus(Set<Long> studyingUserIds, Set<Long> pastUserIds, Set<Long> toChargeUserIds, Set<Long> leftClassHourUserIds, Long orgId, Integer leftMin, Integer leftMax, Set<Long> ownCourseIds) {
        StudentClassHour classHour;
        if (ownCourseIds != null && ownCourseIds.size() == 0) {
            return;
        }
        Set<StudentClass> studentClassSet = this.queryStudentClass(orgId);
        log.info("all studentClassSet' size is : {} ", (Object)studentClassSet.size());
        StringBuilder sb = new StringBuilder();
        sb.append("id:ch_* AND user_id:* AND del_status:0 ");
        if (ownCourseIds != null) {
            sb.append(" AND ").append(SolrUtil.or("course_id", ownCourseIds));
        } else {
            sb.append("AND course_id:*");
        }
        sb.append(" AND org_id:" + orgId);
        SolrDocumentList list = this.getDocumentList(collection, sb.toString());
        Date now = new Date();
        HashMap<String, StudentClassHour> classHourMap = new HashMap<String, StudentClassHour>();
        HashSet<Long> lessonUserIds = new HashSet<Long>();
        for (SolrDocument document : list) {
            Long userId = (Long)document.get((Object)"user_id");
            Long courseId = (Long)document.get((Object)"course_id");
            Date startTime = (Date)document.get((Object)"lesson_start_time");
            classHour = new StudentClassHour();
            String key = userId + "_" + courseId;
            if (classHourMap.get(key) == null) {
                classHour.setCourseId(courseId);
                classHour.setUserId(userId);
                classHourMap.put(key, classHour);
            } else {
                classHour = (StudentClassHour)classHourMap.get(key);
            }
            if (startTime.compareTo(now) > 0) {
                leftClassHourUserIds.add(classHour.getUserId());
                classHour.setLeftClassHour(classHour.getLeftClassHour() + 1);
            } else {
                pastUserIds.add(classHour.getUserId());
                classHour.setFinishClassHour(classHour.getFinishClassHour() + 1);
            }
            lessonUserIds.add(classHour.getUserId());
            studentClassSet.remove(new StudentClass(classHour.getUserId(), classHour.getCourseId()));
        }
        Set<Long> noDelUserIds = this.filterDeletedStudents(lessonUserIds, orgId);
        leftClassHourUserIds.retainAll(noDelUserIds);
        pastUserIds.retainAll(noDelUserIds);
        pastUserIds.removeAll(leftClassHourUserIds);
        HashSet<Long> noLessonUserIds = new HashSet<Long>();
        for (StudentClass sc : studentClassSet) {
            noLessonUserIds.add(sc.getUserId());
        }
        log.info("before filter noLessonUserIds ,the pastUserIds'size is{} ", (Object)pastUserIds.size());
        pastUserIds.removeAll(noLessonUserIds);
        log.info("after filter noLessonUserIds ,the pastUserIds'size is{} ", (Object)pastUserIds.size());
        Set<Long> allUserIds = this.queryAllUserIds(orgId, ownCourseIds);
        allUserIds.removeAll(pastUserIds);
        studyingUserIds.addAll(allUserIds);
        noLessonUserIds.removeAll(leftClassHourUserIds);
        for (String stuCourseId : classHourMap.keySet()) {
            classHour = (StudentClassHour)classHourMap.get(stuCourseId);
            log.info("classHour is : {} and rate is : {} ", (Object)classHour, (Object)classHour.getClassHourRatio());
            if (leftMax != null) {
                if (leftMin == null) {
                    leftMin = 0;
                }
                if (classHour.getLeftClassHour() < leftMin || classHour.getLeftClassHour() > leftMax) {
                    leftClassHourUserIds.remove(classHour.getUserId());
                }
            }
            if (!noDelUserIds.contains(classHour.getUserId()) || classHour.getLeftClassHour() <= 0 || classHour.getClassHourRatio().compareTo(new BigDecimal("0.20")) > 0) continue;
            toChargeUserIds.add(classHour.getUserId());
        }
        log.info("Left classHour Student=" + leftClassHourUserIds);
        if (leftMin != null && leftMin == 0) {
            leftClassHourUserIds.addAll(pastUserIds);
            leftClassHourUserIds.addAll(noLessonUserIds);
        }
        log.info("NO Lesson Student=" + noLessonUserIds);
        log.info("Left classHour Student=" + leftClassHourUserIds);
        log.info("Studying Student=" + studyingUserIds);
        log.info("Past Student=" + pastUserIds);
        log.info("To Charge Student=" + toChargeUserIds);
    }

    private Set<Long> queryAllUserIds(long orgId, Set<Long> ownCourseIds) {
        HashSet<Long> allIds = new HashSet<Long>();
        String queryStr = "id:s_* AND del_status:0 AND org_id:" + orgId;
        if (ownCourseIds != null) {
            Set<Long> allStudents = this.searchAllStudentWithCourseIds(ownCourseIds, orgId);
            if (GenericsUtils.isNullOrEmpty(allStudents)) {
                return Collections.emptySet();
            }
            return allStudents;
        }
        SolrDocumentList list = this.getDocumentList(collection, queryStr);
        for (SolrDocument doc : list) {
            Long userId = (Long)doc.get((Object)"user_id");
            allIds.add(userId);
        }
        return allIds;
    }

    private Set<Long> filterDeletedStudents(Set<Long> userIds, long orgId) {
        StringBuilder sb = new StringBuilder();
        HashSet<Long> noDeleteUserIds = new HashSet<Long>();
        if (userIds == null || userIds.size() < 1) {
            return noDeleteUserIds;
        }
        sb.append("id:s_* AND del_status:0 AND ").append("org_id:" + orgId + " AND ").append(SolrUtil.or("user_id", userIds));
        SolrDocumentList list = this.getDocumentList(collection, sb.toString());
        for (SolrDocument doc : list) {
            Long userId = (Long)doc.get((Object)"user_id");
            noDeleteUserIds.add(userId);
        }
        return noDeleteUserIds;
    }

    public Set<StudentClass> queryStudentClass(long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:e_* AND ").append(" org_id:" + orgId);
        SolrDocumentList list = this.getDocumentList(collection, sb.toString());
        HashSet<StudentClass> studentClassSet = new HashSet<StudentClass>();
        for (SolrDocument document : list) {
            Long userId = (Long)document.get((Object)"user_id");
            Long courseId = (Long)document.get((Object)"course_id");
            studentClassSet.add(new StudentClass(userId, courseId));
        }
        return studentClassSet;
    }

    @Override
    public Set<Long> queryUserIdsByTag(String tag, Long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:t_* AND ").append(" org_id:" + orgId).append(" AND content:*" + tag + "*");
        SolrQuery query = new SolrQuery();
        log.info("[Solr] query tag param:" + sb.toString());
        query.setQuery(sb.toString());
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        QueryResponse response = null;
        HashSet<Long> userIds = new HashSet<Long>();
        try {
            response = this.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList list = response.getResults();
            log.info("[Solr] query tag result:" + list.getNumFound());
            for (SolrDocument doc : list) {
                Long userId = (Long)doc.get((Object)"user_id");
                userIds.add(userId);
            }
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return userIds;
    }

    private Set<Long> queryUserIdsByEnrollTime(Date startTime, Date endTime, long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:e_* AND del_status:0 AND ").append(" org_id:" + orgId);
        if (startTime != null && endTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            sb.append(" AND enroll_time:[" + sdf.format(startTime) + " TO " + sdf.format(endTime) + "}");
        }
        HashSet<Long> userIds = new HashSet<Long>();
        SolrDocumentList list = this.getDocumentList(collection, sb.toString());
        log.info("[Solr] query enroll result:" + list.getNumFound());
        for (SolrDocument doc : list) {
            Long userId = (Long)doc.get((Object)"user_id");
            userIds.add(userId);
        }
        return userIds;
    }

    @Override
    public List<StudentDto> queryStudent(StudentQueryParam param, PageDto pageDto) {
        log.info("QueryParam=" + param.toString());
        List<StudentDto> retList = new ArrayList<StudentDto>();
        Set<Long> ownCourseIds = null;
        if (param.isNeedQueryByAuthority() && GenericsUtils.isNullOrEmpty(ownCourseIds = this.searchCourse(param.getOrgId(), param.getCasCadeId(), param.getOrgNumber()))) {
            log.info("current account has no course belong to it ,and will return an empty collection");
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("id:s_* AND del_status:0 AND org_id:" + param.getOrgId());
        SolrQuery query = new SolrQuery();
        LinkedHashSet<Object> querySet = null;
        try {
            if (param.getStatus() != null && param.getStatus() != StudentLessonStatus.ALL || param.getLeftMaxClassHour() != null) {
                LinkedHashSet<Long> studyingStuIds = new LinkedHashSet<Long>();
                LinkedHashSet<Long> pastStuIds = new LinkedHashSet<Long>();
                LinkedHashSet<Long> toChargeStuIds = new LinkedHashSet<Long>();
                LinkedHashSet<Long> leftClassHourUserIds = new LinkedHashSet<Long>();
                this.queryUserIdsByStatus(studyingStuIds, pastStuIds, toChargeStuIds, leftClassHourUserIds, param.getOrgId(), param.getLeftMinClassHour(), param.getLeftMaxClassHour(), ownCourseIds);
                if (param.getStatus() == StudentLessonStatus.STUDYING) {
                    querySet = studyingStuIds;
                } else if (param.getStatus() == StudentLessonStatus.PAST) {
                    querySet = pastStuIds;
                } else if (param.getStatus() == StudentLessonStatus.TO_CHARGE) {
                    querySet = toChargeStuIds;
                }
                if (param.getLeftMaxClassHour() != null) {
                    if (querySet != null) {
                        querySet.retainAll(leftClassHourUserIds);
                    } else {
                        querySet = new LinkedHashSet();
                        querySet.addAll(leftClassHourUserIds);
                    }
                }
                if (querySet.size() < 1) {
                    log.info("[Solr]No Student.");
                    return Collections.emptyList();
                }
            } else if (param.isNeedQueryByAuthority()) {
                querySet = new LinkedHashSet<Long>();
                querySet.addAll(this.searchAllStudentWithCourseIds(ownCourseIds, param.getOrgId()));
            }
            log.info("querySet=" + querySet + ";StudentIds=" + param.getStudentIds());
            if (param.getStudentIds() != null && param.getStudentIds().size() > 0) {
                if (querySet != null) {
                    querySet.retainAll(param.getStudentIds());
                } else {
                    querySet = new LinkedHashSet();
                    querySet.addAll(param.getStudentIds());
                }
                if (querySet.isEmpty()) {
                    return Collections.emptyList();
                }
            }
            TimeRange range = null;
            Set<Long> enrollUserIds = null;
            if (param.getEnrollTime() != null) {
                range = param.getEnrollTime().timeRange();
                enrollUserIds = this.queryUserIdsByEnrollTime(range.getStartTime(), range.getEndTime(), param.getOrgId());
            }
            if (param.getOpType() != null && param.getOpType() == OpType.ENROLL) {
                enrollUserIds = this.queryUserIdsByEnrollTime(DateUtil.getStartOfDay((Date)DateUtil.getOffSetDate((Date)new Date(), (int)-6)), DateUtil.getStartOfDay((Date)DateUtil.getOffSetDate((Date)new Date(), (int)1)), param.getOrgId());
            }
            log.info("querySet=" + querySet);
            if (enrollUserIds != null) {
                if (querySet != null) {
                    querySet.retainAll(enrollUserIds);
                } else {
                    querySet = new LinkedHashSet();
                    querySet.addAll(enrollUserIds);
                }
                if (querySet.isEmpty()) {
                    return Collections.emptyList();
                }
            }
            log.info("querySet=" + querySet + ";StudentIds=" + param.getStudentIds());
            if (param.getLessonStatus() != null) {
                if (param.getLessonStatus() == 1) {
                    query.setFilterQueries(new String[]{"{!join from=sl_user_id to=user_id }sl_user_id:*"});
                } else {
                    query.setFilterQueries(new String[]{"-{!join from=sl_user_id to=user_id }sl_user_id:*"});
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            if (param.getOpType() != null) {
                Date start = null;
                Date end = null;
                switch (param.getOpType()) {
                    case FOLLOW: {
                        start = DateUtil.getStartOfDay((Date)new Date());
                        end = DateUtil.getEndOfDay((Date)DateUtil.getOffSetDate((Date)start, (int)6));
                        sb.append(" AND ");
                        sb.append("next_remind_time:");
                        sb.append("[" + sdf.format(start) + " TO " + sdf.format(end) + "]");
                        break;
                    }
                    case CREATE: {
                        end = DateUtil.getEndOfDay((Date)new Date());
                        start = DateUtil.getStartOfDay((Date)DateUtil.getOffSetDate((Date)new Date(), (int)-6));
                        sb.append(" AND ");
                        sb.append("create_time:");
                        sb.append("[" + sdf.format(start) + " TO " + sdf.format(end) + "]");
                        break;
                    }
                    default: {
                        log.info("[Solr] OPType=" + (Object)((Object)param.getOpType()));
                    }
                }
            }
            if (param.getCreateTime() != null) {
                range = param.getCreateTime().timeRange();
                sb.append(" AND ");
                sb.append("create_time:[" + sdf.format(range.getStartTime()) + " TO " + sdf.format(range.getEndTime()) + "}");
            }
            if (param.getFollowTime() != null) {
                range = param.getFollowTime().timeRange();
                sb.append(" AND ");
                sb.append("next_remind_time:[" + sdf.format(range.getStartTime()) + " TO " + sdf.format(range.getEndTime()) + "}");
            }
            if (param.getGender() != null) {
                sb.append(" AND ").append("gender:").append(param.getGender());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getSearchKey())) {
                sb.append(" AND (mobile:*").append(param.getSearchKey()).append("* OR name:*").append(param.getSearchKey()).append("* OR pinyin:*").append(param.getSearchKey()).append("* OR parent_mobile:*").append(param.getSearchKey()).append("* OR parent_name:*").append(param.getSearchKey()).append("*");
                Set<Long> ids = this.queryUserIdsByTag(param.getSearchKey(), param.getOrgId());
                if (ids != null && ids.size() > 0) {
                    sb.append(" OR ").append(SolrUtil.or("user_id", ids));
                }
                sb.append(" )");
            }
            int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            int limit = pageDto.getPageSize();
            log.info("Solr QueryParam=" + query.toString() + "=========Start=" + start + ";limit=" + limit);
            query.setStart(Integer.valueOf(start));
            query.setRows(Integer.valueOf(limit));
            query.addSort("pinyin", SolrQuery.ORDER.asc);
            String queryStr = sb.toString();
            long total = 0L;
            log.info("[Solr] querySet=" + querySet);
            if (querySet != null && querySet.size() > 0 && querySet.size() > MAX_QUERY_LIMIT) {
                ArrayList<Object> list = new ArrayList<Object>(querySet.size());
                list.addAll(querySet);
                int i = 0;
                while (i * MAX_QUERY_LIMIT < querySet.size()) {
                    int from = i * MAX_QUERY_LIMIT;
                    int to = Math.min((i + 1) * MAX_QUERY_LIMIT, querySet.size());
                    query.setStart(Integer.valueOf(0));
                    query.setRows(Integer.valueOf(MAX_QUERY_LIMIT));
                    List subList = list.subList(from, to);
                    String str = SolrUtil.or("user_id", subList);
                    String executeQueryStr = queryStr + " AND " + str;
                    query.setQuery(executeQueryStr);
                    log.info("[Solr] student query param= " + executeQueryStr);
                    QueryResponse response = this.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
                    SolrDocumentList documentList = response.getResults();
                    Iterator iterator = documentList.iterator();
                    while (iterator.hasNext()) {
                        StudentDto sd = this.buildStudent((SolrDocument)iterator.next());
                        retList.add(sd);
                    }
                    ++i;
                }
                if (start > retList.size()) {
                    return Collections.emptyList();
                }
                total = retList.size();
                Collections.sort(retList, new Comparator<StudentDto>(){

                    @Override
                    public int compare(StudentDto o1, StudentDto o2) {
                        return o1.getPinyin().compareTo(o2.getPinyin());
                    }
                });
                retList = retList.subList(start, Math.min(retList.size(), start + limit));
                pageDto.setCount(Integer.valueOf((int)total));
                log.info("[Solr] Query count=" + total);
                this.setClassInfo(retList, param.getOrgId(), ownCourseIds);
                return retList;
            }
            if (querySet != null && querySet.size() > 0) {
                queryStr = queryStr + " AND " + SolrUtil.or("user_id", querySet);
            }
            log.info("[Solr] student query param= " + queryStr);
            query.setQuery(queryStr);
            QueryResponse response = this.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList documentList = response.getResults();
            Iterator iterator = documentList.iterator();
            while (iterator.hasNext()) {
                retList.add(this.buildStudent((SolrDocument)iterator.next()));
            }
            total = documentList.getNumFound();
            pageDto.setCount(Integer.valueOf((int)total));
            log.info("[Solr] Query count=" + total);
            this.setClassInfo(retList, param.getOrgId(), ownCourseIds);
        }
        catch (Exception e) {
            log.error("[Solr] Exception ", (Throwable)e);
        }
        return retList;
    }

    @Deprecated
    private Map<Long, Long> queryForCourseByStudents(Collection<Long> subList, Long orgId, Map<String, Integer> courseLeftTimes, Set<Long> ownCourseIds) {
        if (GenericsUtils.isNullOrEmpty(subList)) {
            return Collections.emptyMap();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("id:ch_* AND ").append(SolrUtil.or("user_id", subList)).append(" AND org_id:").append(orgId);
        if (GenericsUtils.notNullAndEmpty(ownCourseIds)) {
            sb.append(" AND ").append(SolrUtil.or("course_id", ownCourseIds));
        }
        SolrDocumentList list = this.getDocumentList(collection, sb.toString());
        Date now = new Date();
        HashMap<Long, Long> studentCourse = new HashMap<Long, Long>();
        for (SolrDocument document : list) {
            Long courseId = (Long)document.get((Object)"course_id");
            Long userId = (Long)document.get((Object)"user_id");
            Long lessonId = (Long)document.get((Object)"lesson_id");
            String key = courseId + "_" + lessonId;
            Date startTime = (Date)document.get((Object)"lesson_start_time");
            Integer times = courseLeftTimes.get(key) == null ? 0 : courseLeftTimes.get(key);
            if (startTime.compareTo(now) > 0) {
                courseLeftTimes.put(key, times + 1);
            }
            studentCourse.put(userId, courseId);
        }
        return studentCourse;
    }

    private Set<Long> searchCourse(Long orgId, Integer casCadeId, Integer orgNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:c_* AND cascade_id:").append(casCadeId).append(" AND org_number:").append(orgNumber);
        SolrQuery query = new SolrQuery();
        query.setQuery(sb.toString());
        query.setStart(Integer.valueOf(0));
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        QueryResponse response = null;
        HashSet<Long> courseIds = new HashSet<Long>();
        try {
            log.info("Solr QueryParam=" + query.toString());
            response = this.getSolr().query(collection, (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList documentList = response.getResults();
            Iterator iterator = documentList.iterator();
            while (iterator.hasNext()) {
                Long cId = (Long)((SolrDocument)iterator.next()).get((Object)"c_self_id");
                courseIds.add(cId);
            }
            long total = documentList.getNumFound();
            log.info("[Solr]  Query all course with orgId:{} and casCadeId:{} , count={}", new Object[]{orgId, casCadeId, total});
            log.info(" all course'Id are : {} ", courseIds);
        }
        catch (SolrServerException e) {
            log.error("[Solr] query consult user SolrServerException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("[Solr] query consult user IOException", (Throwable)e);
        }
        return courseIds;
    }

    private Set<Long> searchAllStudentWithCourseIds(Set<Long> courseIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(courseIds)) {
            return Collections.emptySet();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("id:e_* AND del_status:0 AND status:0 AND org_id:").append(orgId);
        sb.append(" AND ").append(SolrUtil.or("course_id", courseIds));
        SolrQuery query = new SolrQuery();
        query.setQuery(sb.toString());
        query.setStart(Integer.valueOf(0));
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        HashSet<Long> studentIds = new HashSet<Long>();
        QueryResponse response = null;
        try {
            log.info("queryStr is : {} ", (Object)sb.toString());
            log.info("Solr QueryParam=" + query.toString());
            response = this.getSolr().query(collection, (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList documentList = response.getResults();
            for (SolrDocument userIdObj : documentList) {
                log.info("find userIdObj is : {}   ", (Object)userIdObj);
                Long sId = (Long)userIdObj.get((Object)"user_id");
                studentIds.add(sId);
            }
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(studentIds)) {
                return null;
            }
            log.info("find all students'size is {} ", (Object)studentIds.size());
            return studentIds;
        }
        catch (SolrServerException e) {
            log.error("[Solr] query consult user SolrServerException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("[Solr] query consult user IOException", (Throwable)e);
        }
        return null;
    }

    private void setClassInfo(List<StudentDto> studentDtos, Long orgId, Set<Long> ownCourseIds) {
        ownCourseIds = ownCourseIds == null ? Collections.emptySet() : ownCourseIds;
        StringBuilder sb = new StringBuilder();
        HashMap<String, StudentClassHour> map = new HashMap<String, StudentClassHour>();
        try {
            if (studentDtos == null || studentDtos.size() < 1) {
                return;
            }
            final Map studentIdMap = CollectionUtils.extractMap(studentDtos, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentDto>(){

                public Long extract(StudentDto studentDto) {
                    return studentDto.getUserId();
                }
            });
            sb.append("id:ch_* AND org_id:" + orgId).append(" AND ").append(SolrUtil.or("user_id", studentIdMap.keySet()));
            SolrQuery query = new SolrQuery();
            query.setQuery(sb.toString());
            query.setRows(Integer.valueOf(Integer.MAX_VALUE));
            QueryResponse response = this.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList list = response.getResults();
            Date now = new Date();
            log.info("[Solr] query class param:" + sb.toString());
            log.info("[Solr] query class result:" + list.size());
            HashMap sscCache = new HashMap();
            for (SolrDocument document : list) {
                Long userId = (Long)document.get((Object)"user_id");
                Long courseId = (Long)document.get((Object)"course_id");
                Date startTime = (Date)document.get((Object)"lesson_start_time");
                StudentClassHour classHour = null;
                String key = userId + "_" + courseId;
                if (map.get(key) == null) {
                    classHour = new StudentClassHour();
                    classHour.setUserId(userId);
                    classHour.setCourseId(courseId);
                    map.put(key, classHour);
                } else {
                    classHour = (StudentClassHour)map.get(key);
                }
                if (startTime.compareTo(now) > 0) {
                    classHour.setLeftClassHour(classHour.getLeftClassHour() + 1);
                } else {
                    classHour.setFinishClassHour(classHour.getFinishClassHour() + 1);
                }
                if (!ownCourseIds.contains(courseId)) continue;
                ArrayList<StudentClassHour> courseList = (ArrayList<StudentClassHour>)sscCache.get(userId);
                if (courseList == null) {
                    courseList = new ArrayList<StudentClassHour>();
                }
                if (courseList.contains(classHour)) continue;
                courseList.add(classHour);
            }
            for (Map.Entry entry : sscCache.entrySet()) {
                List courseList = (List)entry.getValue();
                if (!GenericsUtils.notNullAndEmpty((Object)courseList)) continue;
                Collections.sort(courseList, new Comparator<StudentClassHour>(){

                    @Override
                    public int compare(StudentClassHour o1, StudentClassHour o2) {
                        return o1.getLeftClassHour() - o2.getLeftClassHour();
                    }
                });
            }
            HashMap<Long, Object> retMap = new HashMap<Long, Object>();
            for (String stuCourseId : map.keySet()) {
                StudentClassHour tempClassHour = (StudentClassHour)map.get(stuCourseId);
                Long userId = tempClassHour.getUserId();
                log.info("[ClassHour]=" + tempClassHour.toString());
                List courseList = (List)sscCache.get(userId);
                if (GenericsUtils.notNullAndEmpty((Object)courseList)) {
                    log.info("find a studentHour obj for userId {} and will retrive the littler one :{} ", courseList.get(0));
                    retMap.put(tempClassHour.getUserId(), courseList.get(0));
                    continue;
                }
                StudentClassHour retClassHour = (StudentClassHour)retMap.get(tempClassHour.getUserId());
                if (retClassHour == null) {
                    retMap.put(tempClassHour.getUserId(), tempClassHour);
                    continue;
                }
                log.info("LeftClassHour=" + tempClassHour.getLeftClassHour() + ":" + retClassHour.getLeftClassHour());
                if (tempClassHour.getLeftClassHour() > 0) {
                    if (retClassHour.getLeftClassHour() <= 0) {
                        retMap.put(tempClassHour.getUserId(), tempClassHour);
                        continue;
                    }
                    if (retClassHour.getLeftClassHour() > tempClassHour.getLeftClassHour()) {
                        retMap.put(tempClassHour.getUserId(), tempClassHour);
                        continue;
                    }
                    if (retClassHour.getLeftClassHour() != tempClassHour.getLeftClassHour() || retClassHour.getCourseId() >= tempClassHour.getCourseId()) continue;
                    retMap.put(tempClassHour.getUserId(), tempClassHour);
                    continue;
                }
                if (retClassHour.getLeftClassHour() > 0 || retClassHour.getCourseId() >= tempClassHour.getCourseId()) continue;
                retMap.put(tempClassHour.getUserId(), tempClassHour);
            }
            Collection values = retMap.values();
            final HashMap courseMap = new HashMap();
            if (values != null && !values.isEmpty()) {
                List courseIds = CollectionUtils.extractList(values, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentClassHour>(){

                    public Long extract(StudentClassHour studentClassHour) {
                        StudentDto dto = (StudentDto)studentIdMap.get(studentClassHour.getUserId());
                        dto.setLeftClassHour(studentClassHour.getLeftClassHour());
                        dto.setFinishClassHour(studentClassHour.getFinishClassHour());
                        ArrayList<StudentDto> list = (ArrayList<StudentDto>)courseMap.get(studentClassHour.getCourseId());
                        if (list != null) {
                            list.add(dto);
                        } else {
                            list = new ArrayList<StudentDto>();
                            list.add(dto);
                            courseMap.put(studentClassHour.getCourseId(), list);
                        }
                        return studentClassHour.getCourseId();
                    }
                });
                String queryStr = SolrUtil.or("c_self_id", courseIds);
                query.setQuery(queryStr);
                log.info("[Solr] Course query param= " + queryStr);
                list = this.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST).getResults();
                log.info("[Solr] Course query param= " + list.size());
                for (SolrDocument doc : list) {
                    Long courseId = (Long)doc.get((Object)"c_self_id");
                    String name = (String)doc.get((Object)"course_name");
                    if (courseMap.get(courseId) == null) continue;
                    for (StudentDto dto : (List)courseMap.get(courseId)) {
                        dto.setClassName(name);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("[Solr] IOException ", (Throwable)e);
        }
        catch (SolrServerException e) {
            log.error("[Solr] SolrServerException ", (Throwable)e);
        }
    }

    private Set<Long> searchExistsCourse(Set<Long> courseIds) {
        HashSet<Long> retSet = new HashSet<Long>();
        if (GenericsUtils.notNullAndEmpty(courseIds)) {
            StringBuilder sb = new StringBuilder();
            sb.append("id:c_* AND is_del:0 ");
            sb.append(" AND ").append(SolrUtil.or("c_self_id", courseIds));
            SolrDocumentList list = this.getDocumentList(collection, sb.toString());
            for (SolrDocument doc : list) {
                Long courseId = (Long)doc.get((Object)"c_self_id");
                retSet.add(courseId);
            }
        }
        return retSet;
    }

    private StudentDto buildStudent(SolrDocument doc) {
        StudentDto stu = new StudentDto();
        stu.setName((String)doc.get((Object)"name"));
        stu.setMobile((String)doc.get((Object)"mobile"));
        stu.setWeixin((String)doc.get((Object)"weixin"));
        stu.setStudentId((Long)doc.get((Object)"s_self_id"));
        stu.setUserId((Long)doc.get((Object)"user_id"));
        stu.setPinyin((String)doc.get((Object)"pinyin"));
        return stu;
    }

    @Override
    public StudentDto queryStudentById(Long userId, Long orgId) {
        StudentDto dto = null;
        StringBuilder sb = new StringBuilder();
        sb.append("id:s_* AND del_status:0 AND org_id:" + orgId);
        sb.append(" AND user_id:" + userId);
        SolrDocumentList list = this.getDocumentList(collection, sb.toString());
        ArrayList<StudentDto> dtos = new ArrayList<StudentDto>();
        for (SolrDocument doc : list) {
            dto = this.buildStudent(doc);
            dtos.add(dto);
        }
        this.setClassInfo(dtos, orgId, null);
        return dto;
    }

    @Override
    public List<StudentClassHour> queryStudentClassHourList(Long userId, Long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:ch_* AND org_id:" + orgId).append(" AND ").append("user_id:" + userId);
        SolrDocumentList list = this.getDocumentList(collection, sb.toString());
        Date now = new Date();
        LinkedHashMap<Long, StudentClassHour> map = new LinkedHashMap<Long, StudentClassHour>();
        for (SolrDocument document : list) {
            Long courseId = (Long)document.get((Object)"course_id");
            Date startTime = (Date)document.get((Object)"lesson_start_time");
            StudentClassHour classHour = null;
            if (map.get(courseId) == null) {
                classHour = new StudentClassHour();
                classHour.setUserId(userId);
                classHour.setCourseId(courseId);
                map.put(courseId, classHour);
            } else {
                classHour = (StudentClassHour)map.get(courseId);
            }
            if (startTime.compareTo(now) > 0) {
                classHour.setLeftClassHour(classHour.getLeftClassHour() + 1);
                continue;
            }
            classHour.setFinishClassHour(classHour.getFinishClassHour() + 1);
        }
        ArrayList<StudentClassHour> ret = new ArrayList<StudentClassHour>();
        ret.addAll(map.values());
        return ret;
    }

    public static void main(String[] args) {
        BigDecimal left = new BigDecimal(0);
        BigDecimal total = new BigDecimal(5);
        BigDecimal rate = left.divide(total, 2, 6);
        System.out.println(rate.compareTo(new BigDecimal("0.2")) <= 0);
    }
}

