/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.solr.query.impl;

import com.baijia.tianxiao.dal.solr.constant.ConsultConstant;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.dal.solr.query.ConsultUserQuery;
import com.baijia.tianxiao.dal.solr.query.impl.SolrAbstractServiceImpl;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultUserQueryImpl
extends SolrAbstractServiceImpl
implements ConsultUserQuery {
    private static final Logger log = LoggerFactory.getLogger(ConsultUserQueryImpl.class);
    private static final String collection = "crm_consultor";
    private static final String collectionOfStudent = "crm_student";
    private static final Long ONE_DAY_TIME = 86400000L;

    @Override
    public List<ConsulterListDto> queryConsulter(Collection<Integer> cascadeIds, ConsulterListQueryParam param, PageDto pageDto) {
        log.info("consulterListQueryParam is : {} ", (Object)param);
        String querySql = this.getconsultUserIds(cascadeIds, param);
        log.info("[solr query is : {} ] ", (Object)querySql);
        ArrayList<ConsulterListDto> retList = new ArrayList<ConsulterListDto>();
        SolrQuery query = new SolrQuery();
        query.setQuery(querySql);
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int limit = pageDto.getPageSize();
        query.setStart(Integer.valueOf(start));
        query.setRows(Integer.valueOf(limit));
        query.addSort("pinyin", SolrQuery.ORDER.asc);
        QueryResponse response = null;
        try {
            log.info("Solr QueryParam=" + query.toString() + "=========Start=" + start + ";limit=" + limit);
            response = this.getSolr().query(collection, (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList documentList = response.getResults();
            Iterator iterator = documentList.iterator();
            while (iterator.hasNext()) {
                retList.add(this.buildConsulterListDto((SolrDocument)iterator.next(), param.getConsulterType()));
            }
            long total = documentList.getNumFound();
            pageDto.setCount(Integer.valueOf((int)total));
            log.info("[Solr] Query count=" + total);
        }
        catch (SolrServerException e) {
            log.error("[Solr] query consult user SolrServerException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("[Solr] query consult user IOException", (Throwable)e);
        }
        return retList;
    }

    private String getconsultUserIds(Collection<Integer> cascadeIds, ConsulterListQueryParam param) {
        Integer notFollowDayNum;
        Integer recentBrowseDayNum;
        Integer backDayNum;
        TimeRange timeRange;
        TimeType tr;
        TimeRange timeRange2;
        Integer setInvalidDayNum;
        Integer createDayNum;
        String keyWrod;
        StringBuilder sb = new StringBuilder();
        sb.append("id:c_*  AND del_status:0").append(" AND is_consulter:").append(param.getIsConsulter());
        sb.append(this.createEquals("org_id", param.getOrgId()));
        if (param.getConsulterType() != ConsultConstant.INVALID && GenericsUtils.notNullAndEmpty(cascadeIds)) {
            sb.append(" AND ").append(SolrUtil.or("cascade_id", cascadeIds));
        }
        if (param.getIsInvalid() != null) {
            sb.append(this.createEquals("is_invalid", param.getIsInvalid()));
        }
        if (param.getSex() != null) {
            sb.append(this.createEquals("sex", param.getSex()));
        }
        if (CollectionUtils.isNotEmpty(param.listConsultSource())) {
            int size = param.listConsultSource().size();
            if (size == 1) {
                sb.append(this.createEquals("consult_source", param.listConsultSource().get(0)));
            } else {
                sb.append(this.createIn("consult_source", param.listConsultSource()));
            }
        }
        if (param.getIntentLevel() != null) {
            sb.append(this.createEquals("intension_level", param.getIntentLevel()));
        }
        if (param.getConsultStatus() != null) {
            sb.append(this.createEquals("consult_status", param.getConsultStatus()));
        }
        if (GenericsUtils.notNullAndEmpty((Object)(keyWrod = param.getKeyword()))) {
            HashMap<String, String> valByField = new HashMap<String, String>();
            valByField.put("name", "*" + keyWrod + "*");
            valByField.put("mobile", "*" + keyWrod + "*");
            valByField.put("pinyin", "*" + keyWrod + "*");
            sb.append(" AND ( ").append(SolrUtil.or(valByField));
            Set<Long> queryConsultIdByTags = this.queryConsultIdByTags(keyWrod, param.getOrgId());
            if (GenericsUtils.notNullAndEmpty(queryConsultIdByTags)) {
                String or = SolrUtil.or("c_self_id", queryConsultIdByTags);
                sb.append(" OR ").append(or);
            }
            sb.append(")");
        }
        sb.append(this.createEquals("student_id", ConsultConstant.CONSULT_STUDENT_ID_DEFAULT_VALUE));
        Integer remindDayNum = param.getRemindDayNum();
        Date now = new Date();
        if (remindDayNum != null) {
            TimeRange timeRange3 = new TimeRange();
            timeRange3.setStartTime(DateUtil.getStartOfDay((Date)now));
            timeRange3.setEndTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() + (long)remindDayNum.intValue() * ONE_DAY_TIME)));
            sb.append(this.createTimeRangeSql("next_remind_time", timeRange3, true));
        }
        if ((createDayNum = param.getCreateDayNum()) != null) {
            TimeRange timeRange4 = new TimeRange();
            timeRange4.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(createDayNum - 1) * ONE_DAY_TIME)));
            timeRange4.setEndTime(now);
            sb.append(this.createTimeRangeSql("create_time", timeRange4, new boolean[0]));
        }
        if ((setInvalidDayNum = param.getInvalidDayNum()) != null) {
            TimeRange timeRange5 = new TimeRange();
            timeRange5.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(setInvalidDayNum - 1) * ONE_DAY_TIME)));
            timeRange5.setEndTime(now);
            sb.append(this.createTimeRangeSql("last_invalid_time", timeRange5, new boolean[0]));
        }
        Integer minRemainingDay = param.getMinRemainingDay();
        Integer maxRemainingDay = param.getMaxRemainingDay();
        if (minRemainingDay != null && maxRemainingDay != null) {
            if (minRemainingDay <= 1) {
                minRemainingDay = 0;
            }
            if (maxRemainingDay <= 1) {
                maxRemainingDay = 1;
            }
            if (minRemainingDay > maxRemainingDay) {
                Integer temp = minRemainingDay;
                minRemainingDay = maxRemainingDay;
                maxRemainingDay = temp;
            }
            Long minDayDept = now.getTime() + (long)minRemainingDay.intValue() * ONE_DAY_TIME;
            Long maxDayDept = now.getTime() + (long)(maxRemainingDay + 1) * ONE_DAY_TIME;
            timeRange2 = new TimeRange();
            timeRange2.setStartTime(DateUtil.getStartOfDay((Date)new Date(minDayDept)));
            timeRange2.setEndTime(DateUtil.getStartOfDay((Date)new Date(maxDayDept)));
            sb.append(this.createTimeRangeSql("finally_hold_time", timeRange2, new boolean[0]));
        }
        if (param.getLastRemindTimeState() != null && (tr = TimeType.getTimeTypeByCode(param.getLastRemindTimeState())) != null) {
            timeRange = tr.timeRange();
            sb.append(this.createTimeRangeSql("last_remind_time", timeRange, true));
        }
        if ((backDayNum = param.getBackDayNum()) != null) {
            timeRange = new TimeRange();
            timeRange.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(backDayNum - 1) * ONE_DAY_TIME)));
            timeRange.setEndTime(now);
            sb.append(this.createTimeRangeSql("last_push_time", timeRange, new boolean[0]));
        }
        if ((recentBrowseDayNum = param.getRecentBrowseDayNum()) != null) {
            timeRange2 = new TimeRange();
            timeRange2.setStartTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(recentBrowseDayNum - 1) * ONE_DAY_TIME)));
            timeRange2.setEndTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() + ONE_DAY_TIME)));
            sb.append(this.createTimeRangeSql("last_browse_time", timeRange2, new boolean[0]));
        }
        if ((notFollowDayNum = param.getUnRemindDayNum()) != null) {
            TimeRange timeRange6 = new TimeRange();
            timeRange6.setStartTime(null);
            timeRange6.setEndTime(DateUtil.getStartOfDay((Date)new Date(now.getTime() - (long)(notFollowDayNum - 1) * ONE_DAY_TIME)));
            sb.append(" AND ((*:* NOT last_remind_time:*) OR ");
            sb.append(this.createTimeRangeSql("last_remind_time", timeRange6, new boolean[0]).replace(" AND ", "")).append(" )");
        }
        log.info("[ Solr Qusery is: {}  ]", (Object)sb.toString());
        return sb.toString();
    }

    private String createEquals(String fieldName, Object value) {
        return " AND " + SolrUtil.equal(fieldName, value) + " ";
    }

    private String createIn(String fieldName, Collection value) {
        return " AND " + SolrUtil.equal(fieldName, value) + " ";
    }

    private String createTimeRangeSql(String fieldName, TimeRange timeRange, boolean ... exclusive) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String firstTimeStr = "*";
        String endTimeStr = "*";
        if (timeRange.getStartTime() != null) {
            firstTimeStr = sdf.format(timeRange.getStartTime());
        }
        if (timeRange.getEndTime() != null) {
            endTimeStr = sdf.format(timeRange.getEndTime());
        }
        StringBuilder tempSql = new StringBuilder();
        tempSql.append(" AND ").append(fieldName).append(":[").append(firstTimeStr).append(" TO ").append(endTimeStr);
        if (GenericsUtils.notNullAndEmpty((Object)exclusive) && exclusive[0]) {
            tempSql.append("}");
        } else {
            tempSql.append("] ");
        }
        return tempSql.toString();
    }

    public ConsulterListDto buildConsulterListDto(SolrDocument doc, Integer consulterType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ConsulterListDto dto = new ConsulterListDto();
        dto.setName((String)doc.get((Object)"name"));
        dto.setMobile((String)doc.get((Object)"mobile"));
        dto.setPortrait((String)doc.get((Object)"portrait"));
        dto.setId((Long)doc.get((Object)"c_self_id"));
        Date finallyHoldTime = (Date)doc.get((Object)"finally_hold_time");
        if (finallyHoldTime != null) {
            log.info("finallyHoldTime is : {} ", (Object)sdf.format(finallyHoldTime));
        }
        Date now = new Date();
        if (finallyHoldTime != null) {
            Long time = finallyHoldTime.getTime();
            int timeDiff = TimeZone.getDefault().getRawOffset() - TimeZone.getTimeZone("GMT").getRawOffset();
            Long time1 = time - (long)timeDiff;
            finallyHoldTime = new Date(time1);
            log.info("finally hold Time is : {} for id:{} ", (Object)sdf.format(finallyHoldTime), (Object)dto.getId());
        }
        Integer lessDayNum = 0;
        if (finallyHoldTime != null && finallyHoldTime.after(now)) {
            lessDayNum = DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).equals(DateUtil.getStartOfDayAccurateToMillSeconde((Date)now)) ? Integer.valueOf(1) : Integer.valueOf((int)((DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).getTime() - DateUtil.getStartOfDayAccurateToMillSeconde((Date)now).getTime()) / ONE_DAY_TIME));
        }
        dto.setTimeRemaining(lessDayNum);
        String inital = (String)doc.get((Object)"pinyin");
        if (GenericsUtils.notNullAndEmpty((Object)inital)) {
            if ((inital = inital.substring(0, 1).toUpperCase()).equals("~")) {
                inital = "#";
            }
        } else {
            inital = "#";
        }
        dto.setInitial(inital);
        dto.setIsInvalid((Integer)doc.get((Object)"is_invalid"));
        dto.setCascadeId((Integer)doc.get((Object)"cascade_id"));
        dto.setConsulterType(consulterType);
        return dto;
    }

    public Set<Long> queryConsultIdByTags(String tag, Long orgId) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:t_* AND ").append(" org_id:").append(orgId).append(" AND content:*").append(tag).append("*").append(" AND user_id:0 ");
        SolrQuery query = new SolrQuery();
        log.info("[Solr] query tag param:" + sb.toString());
        query.setQuery(sb.toString());
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        StringBuilder fq1 = new StringBuilder("-t_consult_user_id:").append("0");
        query.addFilterQuery(new String[]{fq1.toString()});
        QueryResponse response = null;
        HashSet<Long> consultUserIds = new HashSet<Long>();
        try {
            response = this.getSolr().query(collectionOfStudent, (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList list = response.getResults();
            log.info("[Solr] query tag result:" + list.getNumFound());
            for (SolrDocument doc : list) {
                Long userId = (Long)doc.get((Object)"t_consult_user_id");
                if (userId == null) continue;
                log.info("find userId is : {} ", (Object)userId);
                consultUserIds.add(userId);
            }
            if (GenericsUtils.isNullOrEmpty(consultUserIds)) {
                return Collections.emptySet();
            }
            return consultUserIds;
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Integer countConsulter(Collection<Integer> cascadeIds, ConsulterListQueryParam param) {
        String queryStr = this.getconsultUserIds(cascadeIds, param);
        SolrQuery query = new SolrQuery();
        query.setQuery(queryStr);
        QueryResponse response = null;
        try {
            log.info("Solr QueryParam=" + query.toString());
            response = this.getSolr().query(collection, (SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList documentList = response.getResults();
            long total = documentList.getNumFound();
            log.info("[Solr] Query count=" + total);
            return (int)total;
        }
        catch (SolrServerException e) {
            log.error("[Solr] query consult user SolrServerException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("[Solr] query consult user IOException", (Throwable)e);
        }
        return 0;
    }
}

