
package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

public interface OrgSinupPurchaseDao extends CommonDao<OrgSinupPurchase> {

    /**
     * 根据订单ID返回机构报名订单信息
     * 
     * @param purchaseId
     * @return
     */
    OrgSinupPurchase getByPurchaseId(Long purchaseId, String...queryProp);

    /**
     * 根据订单ID批量查找订单
     * 
     * @param purchaseIds
     * @param queryProp
     * @return
     */
    List<OrgSinupPurchase> getByPurchaseIds(Collection<Long> purchaseIds, String...queryProp);

    /**
     * @param status
     * @param upateTime
     * @param maxSize
     * @return
     */
    List<OrgSinupPurchase> searchByUpdateTimeAndStatus(Integer status, Date updateTime, Integer maxSize,
        String...queryProp);

    /**
     * 根据订单ID获取订单状态
     * 
     * @param purchaseId
     * @return
     */
    Integer getPurchaseStatusByPurchaseId(Long purchaseId);

    /**
     * 根据订单号获取支付类型
     * 
     * @param purchaseId
     * @return
     */
    String getPayType(Long purchaseId);

    /**
     * 批量查询支付类型
     * 
     * @param purchaseIds
     * @return
     */
    Map<Long, String> getPayTypes(Collection<Long> purchaseIds, Integer status);


    List<OrgSinupPurchase> getOrgSinupPurchase(Integer status, Date startTime, Integer orgId,
                                               String...queryProp);

}

    