/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author shizuwei
 * @version 1.0
 * @title CoursePurchase
 * @desc pay.course_purchase
 * @date 2015年12月3日
 */

@Data
@Entity
@Table(name = "course_purchase", catalog = "pay")
public class CoursePurchase {

    /**
     * 主键
     */
    @Id
    @GeneratedValue
    private Long id;

    /**
     * 流水号
     */
    @Column
    private Long purchaseId;

    /**
     * 支付类型
     */
    @Column
    private String payType;

    /**
     * 交易状态：0 交易中，1交易完成，2交易失败，3交易取消
     */
    @Column
    private Integer status;

    /**
     * 订单所属用户
     */
    @Column
    private Long userId;

    /**
     * 学生用户姓名
     */
    @Column
    private String userName;

    /**
     * 老师user_id
     */
    @Column
    private Long teacherUserId;

    /**
     * 老师用户名
     */
    @Column
    private String teacherUserName;

    /**
     * 订单总价
     */
    @Column
    private Double totalPrices;

    /**
     * 实付金额
     */
    @Column
    private Double payMoney;

    /**
     * 第三方支付金额
     */
    private Double total_fee;

    /**
     * 唯一编号,暴露给对外接口
     */
    @Column
    private Long courseNumber;

    /**
     * 所买老师课程id
     */
    @Column
    private Long courseId;

    /**
     * 1:一对一,2:班课
     */
    @Column
    private Integer courseType;

    /**
     * 机构id
     */
    @Column(name = "organization_id")
    private Long orgId;

    /**
     *
     */
    @Column
    private Date payTime;

    @Column
    private Long parentPurchaseId;

    /**
     * 手续费
     */
    @Column
    private Double poundage;

    /**
     * 创建时间
     */
    @Column
    private Date createTime;

    /**
     * 跟新时间
     */
    @Column
    private Date updateTime;
}
