package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by wengshengli on 16/1/7.
 */
public interface OrgFinanceAccountRecordDao extends CommonDao<OrgFinanceAccountRecord> {

    double sumIncomeByTime(long orgId, List<Integer> opTypes, Date startDate, Date endDate, String... queryProps);

    double sumDrawcashMoney(long orgId);

    Map<Long, Double> sumIncomeTotal(Date startDate, Date endDate, List<Long> tianxiaoOrgIds);

    /**
     * 当前最近一条记录
     *
     * @param orgId
     * @param thisDate
     * @return
     */
    OrgFinanceAccountRecord currentAccount(Long orgId, Date thisDate, String... queryProps);

    List<OrgFinanceAccountRecord> getFinanceRecordListByMinId(Long minId, Date lastDate, int maxSize, String... queryProps);

    Integer maxFinanceInfoRecordId();

}
