package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.base.Preconditions;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wengshengli on 16/1/7.
 */
@Repository
public class OrgFinanceAccountRecordDaoImpl extends JdbcTemplateDaoSupport<OrgFinanceAccountRecord>
        implements OrgFinanceAccountRecordDao {

    public OrgFinanceAccountRecordDaoImpl() {
        super(OrgFinanceAccountRecord.class);
    }

    @Override
    public double sumIncomeByTime(long orgId, List<Integer> opTypes, Date startDate, Date endDate,
                                  String... queryProps) {
        SingleSqlBuilder<OrgFinanceAccountRecord> builder = createSqlBuilder(queryProps);
        builder.sum("opMoney");
        builder.eq("orgId", orgId);
        builder.eq("isShow", 1);
        builder.in("opType", opTypes);// (1,2)
        builder.ge("createTime", startDate);
        builder.le("createTime", endDate);

        return queryForObject(builder, Double.class);
    }


    @Override
    public OrgFinanceAccountRecord currentAccount(Long orgId, Date thisDate, String... queryProps) {
        SingleSqlBuilder<OrgFinanceAccountRecord> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.le("createTime", thisDate);
        builder.desc("createTime");
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }

    @Override
    public Map<Long, Double> sumIncomeTotal(Date startDate, Date endDate, List<Long> tianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", tianxiaoOrgIds);
        String sql =
                "select org_id, sum(op_money) opMoney from yunying.org_finance_account_record where op_type in (1,2) and is_show = 1 and org_id in (:orgIds)";
        if (startDate != null && endDate != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql += " group by org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Double>>() {

            @Override
            public Map<Long, Double> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Double> map = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Double opMoney = rs.getDouble("opMoney");
                    map.put(orgId, opMoney);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgFinanceAccountRecord> getFinanceRecordListByMinId(Long minId, Date lastDate, int maxSize, String... queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<OrgFinanceAccountRecord> builder = createSqlBuilder(queryProps);
        if (minId == null || minId == 0) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", lastDate);
        } else {
            builder.gt("id", minId);
        }

        builder.setMaxSize(maxSize);
        return queryList(builder);
    }


    @Override
    public double sumDrawcashMoney(long orgId) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgId", orgId);
        //String sql = "select ifnull(sum(op_money),0) from (select op_money from yunying.org_finance_account_record where org_id = :orgId and op_type in (3,4,5) group by purchase_id having count(purchase_id)=1) a";
        String sql="select ifnull(sum(amount),0) from yunying.cw_draw_cash_purchase where user_id = :orgId and status not in (2,3,5) and user_type in (3,8)";

        Double money = this.getNamedJdbcTemplate().queryForObject(sql, param, Double.class);
        return money == null ? 0 : money.doubleValue();
    }

    @Override
    public Integer maxFinanceInfoRecordId() {
        SingleSqlBuilder<OrgFinanceAccountRecord> builder = createSqlBuilder();
        builder.max("id");
        return queryForObject(builder, Integer.class);
    }
}
