/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgFinanceAccountRecordDaoImpl
extends JdbcTemplateDaoSupport<OrgFinanceAccountRecord>
implements OrgFinanceAccountRecordDao {
    public OrgFinanceAccountRecordDaoImpl() {
        super(OrgFinanceAccountRecord.class);
    }

    @Override
    public double sumIncomeByTime(long orgId, List<Integer> opTypes, Date startDate, Date endDate, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.sum("opMoney");
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("isShow", (Serializable)Integer.valueOf(1));
        builder.in("opType", opTypes);
        builder.ge("createTime", (Serializable)startDate);
        builder.le("createTime", (Serializable)endDate);
        return (Double)this.queryForObject(builder, Double.class);
    }

    @Override
    public OrgFinanceAccountRecord currentAccount(Long orgId, Date thisDate, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.le("createTime", (Serializable)thisDate);
        builder.desc("createTime");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgFinanceAccountRecord)this.uniqueResult(builder);
    }

    @Override
    public Map<Long, Double> sumIncomeTotal(Date startDate, Date endDate, List<Long> tianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", tianxiaoOrgIds);
        String sql = "select org_id, sum(op_money) opMoney from yunying.org_finance_account_record where op_type in (1,2) and is_show = 1 and org_id in (:orgIds)";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Double>>(){

            public Map<Long, Double> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Double> map = new HashMap<Long, Double>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Double opMoney = rs.getDouble("opMoney");
                    map.put(orgId, opMoney);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgFinanceAccountRecord> getFinanceRecordListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public double sumDrawcashMoney(long orgId) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("orgId", orgId);
        String sql = "select ifnull(sum(amount),0) from yunying.cw_draw_cash_purchase where user_id = :orgId and status not in (2,3,5) and user_type in (3,8)";
        Double money = (Double)this.getNamedJdbcTemplate().queryForObject(sql, param, Double.class);
        return money == null ? 0.0 : money;
    }

    @Override
    public Integer maxFinanceInfoRecordId() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.max("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }
}

