/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年4月21日
 * @desc
 */
@Data
@Entity
@Table(name = "draw_cash_purchase ", catalog = "pay")
public class DrawCashPurchase {
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;
    @Column(name = "purchase_id") // 流水账号
    private Long purchaseId;
    @Column(name = "status") // 交易状态：0 提现未处理，1 提现等待，2 处理成功，3处理失败 4 财务审核中 5 被驳回 6等待自动转账
    private Integer status;
    @Column(name = "bank_card_id")
    private Long bankCardId;
    @Column(name = "user_type") // 用户角色：0 老师，2 学生，3 机构，9 渠道
    private Integer userType;
    @Column(name = "user_id")
    private Long userId; // 订单所属的用户
    @Column(name = "user_name")
    private String userName; // 学生用户名
    @Column(name = "amount")
    private Double amount; // 订单金额
    @Column(name = "create_time")
    private Date create_time;
    @Column(name = "opt_id")
    private Long opt_id; // 专员id
    @Column(name = "update_time")
    private Date updateTime; // 订单完成的时间
    @Column(name = "dispatch_time")
    private Date dispatch_time; // 分配时间
    @Column(name = "manager_id")
    private Long managerId; // 经理id
    @Column(name = "director_id")
    private Long directorId; // 主管id
    @Column(name = "trade_no")
    private String tradeNo;// 票据号
    @Column(name = "detail")
    private String detail;// 备注
    @Column(name = "pay_amount")
    private Double payAmount;// 实际支付金额
    @Column(name = "fee_money")
    private Double fee_money;// 需要扣除的手续费
    @Column(name = "client")
    private Integer client;// 客户端类型，参考UserLoginLog
    @Column(name = "card_owner_name")
    private String cardOwnerName;// 银行卡开卡人名
    @Column(name = "bank_name")
    private String bankName;// 银行名称
    @Column(name = "card_open_location")
    private String cardOpenLocation;
    @Column(name = "card_num")
    private String cardNum;
    @Column(name = "bank_no")
    private String bankNo; // 银行代号
    @Column(name = "region")
    private String region;// 省市县
    @Column(name = "bank_id")
    private String bankId;// 银行卡编码
    @Column(name = "id_number")
    private String idNumber;// 身份证
    @Column(name = "mobile")
    private String mobile;// 银行预留手机号
    @Column(name = "card_status")
    private Integer cardStatus;// 银行卡状态,0-未认证，1-已认证

}
