package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;

/**
 * Created by wengshengli on 16/1/7.
 */

import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.sql.Timestamp;

import lombok.Data;

@Data
@Entity
@Table(name = "org_finance_account_record", catalog = "yunying")
public class OrgFinanceAccountRecord {

    // Id
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Integer id;
    // 机构账户
    @Column(name = "org_id")
    private Long orgId;
    // 机构名称
    @Column(name = "org_name")
    private String orgName;
    // 操作前余额
    @Column(name = "pre_balance")
    private Double preBalance;
    // 操作后余额
    @Column(name = "curr_balance")
    private Double currBalance;
    // 冻结前金额
    @Column(name = "pre_freeze_money")
    private Double preFreezeMoney;
    // 冻结后金额
    @Column(name = "curr_freeze_money")
    private Double currFreezeMoney;
    // 操作前总收入
    @Column(name = "pre_income")
    private Double preIncome;
    // 操作后总收入
    @Column(name = "curr_income")
    private Double currIncome;
    // 操作前预期收入
    @Column(name = "pre_expected_earning")
    private Double preExpectedEarning;
    // 操作后预期收入
    @Column(name = "curr_expected_earning")
    private Double currExpectedEarning;
    // 操作类型 1=老师转入，2提现
    @Column(name = "op_type")
    private Integer opType;
    // 操作说明
    @Column(name = "op_info")
    private String opInfo;
    // 创建时间
    @Column(name = "create_time")
    private Timestamp createTime;

    // 交易流水号
    @Column(name = "purchase_id")
    private Long purchaseId;
    // 交易金额
    @Column(name = "op_money")
    private Double opMoney;
    // 老师ID
    @Column(name = "teacher_id")
    private Long teacherId;

    private String businessInfo;

    private Timestamp businessTime;

    @Column(name = "pay_type")
    private String payType;

    @Column(name = "op_status")
    private Integer opStatus;

    @Column(name = "note")
    private String note;

    @Column(name = "order_lesson_id")
    private Long orderLessonId;

    @Column(name = "op_money_type")
    private Integer opMoneyType;

    @Column(name = "curr_pay_type")
    private String currPayType;

    @Column(name = "activity_source_user_role")
    private Integer activitySourceUserRole;

    @Column(name = "is_show")
    private Integer isShow = 1; // 前端显示

    // 优惠券id
    private Integer activityAccountId;

    @Column(name = "dest_id")
    private Long destId;

    // 交易描述
    @Column(name = "op_desc")
    private String opDesc;

}
