package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.BatchQueryTemplate;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Repository
public class OrgSinupPurchaseDaoImpl extends JdbcTemplateDaoSupport<OrgSinupPurchase> implements OrgSinupPurchaseDao {

    public OrgSinupPurchaseDaoImpl() {
        super(OrgSinupPurchase.class);
    }

    @Override
    public OrgSinupPurchase getByPurchaseId(Long purchaseId, String...queryProp) {
        SingleSqlBuilder<OrgSinupPurchase> builder = createSqlBuilder(queryProp);
        builder.eq("purchaseId", purchaseId);
        return uniqueResult(builder);

    }

    @Override
    public List<OrgSinupPurchase> getByPurchaseIds(Collection<Long> purchaseIds, final String...queryProp) {
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate<Long, OrgSinupPurchase> queryTemplate = new ListBatchQueryTemplate<>();
        return queryTemplate.batchQuery(purchaseIds, new BatchQueryCallback<Long, List<OrgSinupPurchase>>() {
            @Override
            public List<OrgSinupPurchase> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<OrgSinupPurchase> builder = createSqlBuilder();
                builder.select(queryProp);
                builder.in("purchaseId", querySet);
                return queryList(builder);
            }
        });
    }

    @Override
    public List<OrgSinupPurchase> searchByUpdateTimeAndStatus(Integer status, Date updateTime, Integer maxSize,
        String...queryProp) {
        Preconditions.checkNotNull(status, "status can not be empty.");
        Preconditions.checkNotNull(updateTime, "update time can not be null");
        SingleSqlBuilder<OrgSinupPurchase> builder = createSqlBuilder();
        builder.select(queryProp);
        builder.eq("status", status);
        builder.gt("updateTime", updateTime);
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        builder.asc("updateTime");
        return queryList(builder);

    }

    @Override
    public Integer getPurchaseStatusByPurchaseId(Long purchaseId) {
        Preconditions.checkNotNull(purchaseId, "purchaseId can not be null.");
        SingleSqlBuilder<OrgSinupPurchase> builder = createSqlBuilder();
        builder.select("status");
        builder.eq("purchaseId", purchaseId);
        return queryForObject(builder, Integer.class);
    }

    @Override
    public String getPayType(Long purchaseId) {
        Preconditions.checkNotNull(purchaseId, "purchaseId can not be null.");
        SingleSqlBuilder<OrgSinupPurchase> builder = createSqlBuilder("payType");
        builder.eq("purchaseId", purchaseId);
        return queryForObject(builder, String.class);
    }

    @Override
    public Map<Long, String> getPayTypes(Collection<Long> purchaseIds, final Integer status) {

        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyMap();
        }
        BatchQueryTemplate<Long, List<OrgSinupPurchase>> batchQueryTemplate = new ListBatchQueryTemplate<>();
        List<OrgSinupPurchase> list =
            batchQueryTemplate.batchQuery(purchaseIds, new BatchQueryCallback<Long, List<OrgSinupPurchase>>() {

                @Override
                public List<OrgSinupPurchase> doQuery(Collection<Long> querySet) {
                    SingleSqlBuilder<OrgSinupPurchase> builder = createSqlBuilder("purchaseId", "payType");
                    builder.in("purchaseId", querySet);
                    builder.eq("status", status);
                    return queryList(builder);
                }
            });
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }

        return CollectorUtil.collectMap(list, new Function<OrgSinupPurchase, Long>() {
            @Override
            public Long apply(OrgSinupPurchase input) {
                return input.getPurchaseId();
            }
        }, new Function<OrgSinupPurchase, String>() {
            @Override
            public String apply(OrgSinupPurchase input) {
                return input.getPayType();
            }
        });

    }

}
