/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年4月28日
 * @desc
 */
@Repository
public class OrgFinanceAccountDaoImpl extends JdbcTemplateDaoSupport<OrgFinanceAccount> implements OrgFinanceAccountDao {

    @Override
    public Map<Long, Double> getcashPurchaseSum(List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);

        String sql = "select org_id, balance, freeze_money from yunying.org_finance_account where org_id in (:orgIds)";

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Double>>() {

            @Override
            public Map<Long, Double> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Double> map = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    double balance = rs.getDouble("balance");
                    double freezeMoney = rs.getDouble("freeze_money");
                    map.put(orgId, balance + freezeMoney);
                }
                return map;
            }
        });
    }


    @Override
    public OrgFinanceAccount getByOrgId(Long orgId, String... queryProps) {
        SingleSqlBuilder<OrgFinanceAccount> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }
}
