package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.dao.dto.CoursePurchaseDto;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface CoursePurchaseDao extends CommonDao<CoursePurchase> {

    /**
     * 根据机构ID,订单状态,最近更新时间查询订单
     */
    List<CoursePurchase> queryByLastUpdateTime(Long orgId, Integer status, Date lastUpdateTime, int maxSize,
                                               String... propes);

    Map<Long, String> queryStudentName(Collection<Long> userIds);

    List<Long> getLatestdPurchaseCourseIdsList(Long orgId);

    /**
     * 获取课程订单
     *
     * @param orgId
     * @param parentPurchaseId (值为0时表示M站订单)
     * @param courseType
     * @param status
     * @return
     */
    List<CoursePurchase> getCoursePurchaseList(Long orgId, Long userId, Long parentPurchaseId, Integer courseType,
                                               Integer status, String... queryPrps);

    /**
     * 获取学生课程订单
     *
     * @param orgId
     * @param userId
     * @param status
     * @return
     */
    List<CoursePurchase> getCoursePurchaseList(Long orgId, Long userId, Integer status, String... queryPrps);

    /**
     * 获取学生课程订单
     *
     * @param orgId
     * @param status
     * @return
     */
    List<CoursePurchase> getCoursePurchaseList(Long orgId, Integer status, String... queryPrps);

    /**
     * 获取更新时间在指定时间之后的订单
     *
     * @param updateTime
     * @param page
     * @param queryPrps
     * @return
     */
    List<CoursePurchase> getCoursePurchaseList(Date updateTime, Integer status, List<Integer> courseTypes, PageDto page,
                                               String... queryPrps);

    /**
     * 同步获取列表(非报名订单)
     *
     * @param minId
     * @param lastDate
     * @param maxSize
     * @param courseType
     * @param status
     * @param queryProps
     * @return
     */
    List<CoursePurchase> getCousePurchaseListByMinId(Long minId, Date lastDate, int maxSize, Integer courseType, Integer parentPurchaseType,
                                                     Integer status, String... queryProps);

    int getTotalOrgPurchase(Long orgId);

    int getOrgPuchaseByTime(Long orgId, Date startDate, Date endDate);

    int getCourseTotalCount(Long orgId, Long courseNum);

    int getCourseTotalCount(Long courseNum);

    int getCourseCountByTime(Long orgId, Long courseNum, Date startDate, Date endDate);

    int getCourseCountByTime(Long orgId, Date startDate, Date endDate);

    List<CoursePurchase> getUnSuccessList4CourseIdUserIdOrgId(int start, int maxSize);

    List<CoursePurchase> getSuccessList(Collection<List<Object>> groupValues);

    /**
     * 统计收入笔数
     *
     * @param startTime
     * @param endTime
     * @return
     */
    Map<Long, CoursePurchaseDto> getIncomeTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);

    public List<CoursePurchase> getByOrgIds(Date startTime, Date endTime, List<Long> orgIds, PageDto pageDto);

    Integer getCountByOrgIds(Date startTime, Date endTime, List<Long> orgIds);

    CoursePurchase getByPurcahseId(Long purchaseId);

    CoursePurchase getByPurcahseIdCourse(Long parentPurchaseId, Long courseId);

    List<CoursePurchase> getByPurcahseIds(Set<Long> purchaseIds);
}
