/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSinupPurchaseDaoImpl
extends JdbcTemplateDaoSupport<OrgSinupPurchase>
implements OrgSinupPurchaseDao {
    public OrgSinupPurchaseDaoImpl() {
        super(OrgSinupPurchase.class);
    }

    @Override
    public OrgSinupPurchase getByPurchaseId(Long purchaseId, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("purchaseId", (Serializable)purchaseId);
        return (OrgSinupPurchase)this.uniqueResult(builder);
    }

    @Override
    public List<OrgSinupPurchase> getByPurchaseIds(Collection<Long> purchaseIds, final String ... queryProp) {
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(purchaseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgSinupPurchase>>(){

            public List<OrgSinupPurchase> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgSinupPurchaseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select(queryProp);
                builder.in("purchaseId", querySet);
                return OrgSinupPurchaseDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgSinupPurchase> searchByUpdateTimeAndStatus(Integer status, Date updateTime, Integer maxSize, String ... queryProp) {
        Preconditions.checkNotNull((Object)status, (Object)"status can not be empty.");
        Preconditions.checkNotNull((Object)updateTime, (Object)"update time can not be null");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("status", (Serializable)status);
        builder.gt("updateTime", (Serializable)updateTime);
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        builder.asc("updateTime");
        return this.queryList(builder);
    }

    @Override
    public Integer getPurchaseStatusByPurchaseId(Long purchaseId) {
        Preconditions.checkNotNull((Object)purchaseId, (Object)"purchaseId can not be null.");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("status");
        builder.eq("purchaseId", (Serializable)purchaseId);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public String getPayType(Long purchaseId) {
        Preconditions.checkNotNull((Object)purchaseId, (Object)"purchaseId can not be null.");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"payType"});
        builder.eq("purchaseId", (Serializable)purchaseId);
        return (String)this.queryForObject(builder, String.class);
    }

    @Override
    public Map<Long, String> getPayTypes(Collection<Long> purchaseIds, final Integer status) {
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyMap();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List list = (List)batchQueryTemplate.batchQuery(purchaseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgSinupPurchase>>(){

            public List<OrgSinupPurchase> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgSinupPurchaseDaoImpl.this.createSqlBuilder(new String[]{"purchaseId", "payType"});
                builder.in("purchaseId", querySet);
                builder.eq("status", (Serializable)status);
                return OrgSinupPurchaseDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return CollectorUtil.collectMap((Collection)list, (Function)new Function<OrgSinupPurchase, Long>(){

            public Long apply(OrgSinupPurchase input) {
                return input.getPurchaseId();
            }
        }, (Function)new Function<OrgSinupPurchase, String>(){

            public String apply(OrgSinupPurchase input) {
                return input.getPayType();
            }
        });
    }
}

