/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgFinanceAccountRecordDaoImpl
extends JdbcTemplateDaoSupport<OrgFinanceAccountRecord>
implements OrgFinanceAccountRecordDao {
    public OrgFinanceAccountRecordDaoImpl() {
        super(OrgFinanceAccountRecord.class);
    }

    @Override
    public double sumIncomeByTime(long orgId, List<Integer> opTypes, Date startDate, Date endDate, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.sum("opMoney");
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("isShow", (Serializable)Integer.valueOf(1));
        builder.in("opType", opTypes);
        builder.ge("createTime", (Serializable)startDate);
        builder.le("createTime", (Serializable)endDate);
        return (Double)this.queryForObject(builder, Double.class);
    }

    @Override
    public Map<Long, Double> sumIncomeTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, sum(op_money) opMoney from yunying.org_finance_account_record where op_type in (1,2) and is_show = 1 and org_id in (:orgIds)";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Double>>(){

            public Map<Long, Double> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Double> map = new HashMap<Long, Double>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Double opMoney = rs.getDouble("opMoney");
                    map.put(orgId, opMoney);
                }
                return map;
            }
        });
    }
}

