/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.im.dao.impl;

import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title ImMessageInfoDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2015年12月8日
 * @version 1.0
 */
@Repository
public class ImMessageInfoDaoImpl extends JdbcTemplateDaoSupport<ImMessageInfo> implements ImMessageInfoDao {

    public ImMessageInfoDaoImpl() {
        super(ImMessageInfo.class);
    }

    @Override
    public List<ImMessageInfo> getOrgStudentInfoListByMinId(Long minId, Date lastDate, int maxSize, String...queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<ImMessageInfo> builder = createSqlBuilder(queryProps);
        builder.max("msgId", "msgId");
        builder.groupByNames("sender", "receiver");
        if (minId == null || minId == 0) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", lastDate);
        } else {
            builder.gt("msgId", minId);
        }
        builder.eq("senderRole", 2);
        builder.eq("receiverRole", 6);
        builder.asc("createTime");
        builder.setMaxSize(maxSize);
        return queryList(builder);
    }

    @Override
    public int getOrgMessageCount(Long orgNumber, Date startTime, Date endTime) {
        String sql =
            "SELECT count(1) FROM hermes.im_message_info_single where receiver_r=6 and receiver=:receiver"
            +" and create_time>=:startTime and create_time<=:endTime";
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("receiver", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        return getNamedJdbcTemplate().queryForInt(sql, paramMap);
    }

    @Override
    public int getOrgMessageTotalCount(Long orgNumber) {
        String sql =
            "SELECT count(1) FROM hermes.im_message_info_single where receiver_r=6 and receiver=:receiver";
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("receiver", orgNumber);
        return getNamedJdbcTemplate().queryForInt(sql, paramMap);
    }

}
