/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.im.dao.impl;

import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class ImMessageInfoDaoImpl
extends JdbcTemplateDaoSupport<ImMessageInfo>
implements ImMessageInfoDao {
    public ImMessageInfoDaoImpl() {
        super(ImMessageInfo.class);
    }

    @Override
    public List<ImMessageInfo> getOrgStudentInfoListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.max("msgId", "msgId");
        builder.groupByNames(new String[]{"sender", "receiver"});
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
        } else {
            builder.gt("msgId", (Serializable)minId);
        }
        builder.eq("senderRole", (Serializable)Integer.valueOf(2));
        builder.eq("receiverRole", (Serializable)Integer.valueOf(6));
        builder.asc("createTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public int getOrgMessageCount(Long orgNumber, Date startTime, Date endTime) {
        String sql = "SELECT count(1) FROM hermes.im_message_info_single where receiver_r=6 and receiver=:receiver and create_time>=:startTime and create_time<=:endTime";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver", orgNumber);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }

    @Override
    public int getOrgMessageTotalCount(Long orgNumber) {
        String sql = "SELECT count(1) FROM hermes.im_message_info_single where receiver_r=6 and receiver=:receiver";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("receiver", orgNumber);
        return this.getNamedJdbcTemplate().queryForInt(sql, (Map)paramMap);
    }
}

