/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.im.dao;

import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;

/**
 * @title ImMessageInfoDao
 * @desc TODO
 * @author cxm
 * @date 2015年12月8日
 * @version 1.0
 */
public interface ImMessageInfoDao extends CommonDao<ImMessageInfo> {

    List<ImMessageInfo> getOrgStudentInfoListByMinId(Long minId, Date lastDate, int maxSize, String...queryProps);

    /**
     * 获取机构IM消息数量
     * @param orgNumber
     * @param startTime
     * @param endTime
     * @return
     */
    int getOrgMessageCount(Long orgNumber, Date startTime, Date endTime);
    
    /**
     * 获取机构IM消息总数
     * @param orgNumber
     * @return
     */
    int getOrgMessageTotalCount(Long orgNumber);

}
