package com.baijia.tianxiao.dal.es.dao.impl;

import com.baijia.tianxiao.dal.es.dao.EsStudentsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author weihongyan
 * @description TODO
 * @date 21/03/2017
 */
@Slf4j
@Component
public class EsStudentDaoImpl extends AbstractEsBaseDao implements EsStudentsDao {
    
    @Autowired
    OrgStudentDao orgStudentDao;
    
    @Override
    public Map<String, Object> getStudentByIndexTypeId(String index, String type, String id){
        TransportClient client = this.getClient();
        GetResponse response = client.prepareGet(index, type, id).get();
//        return objectMapper.readValue(response.getSourceAsString(), OrgStudent.class);
        return response.getSource();
    }

    @Override
    @SneakyThrows
    @Transactional(readOnly = true)
    public void importAllOrgStudentFromDbToEs(String index, String type) {
        
        long time = System.currentTimeMillis();
        
        BulkProcessor bulkProcessor = BulkProcessor.builder(this.getClient(), new BulkProcessor.Listener() {
            @Override
            public void beforeBulk(long executionId, BulkRequest request) {
                log.info("going to bulk, executionId:{}, numOfActions:{}", executionId, request.numberOfActions());
            }
            @Override
            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                log.info("bulk ok, executionId:{}, numOfActions:{}, costs:{}ms, hasFailures:{}",
                    executionId, request.numberOfActions(), response.getTookInMillis(), response.hasFailures());
            }
            @Override
            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                log.error("bulk failed!, error:{}", failure);
            }
        }).setConcurrentRequests(3).setBulkActions(10000).setBulkSize(new ByteSizeValue(10, ByteSizeUnit.MB)).build();

        PageDto page = new PageDto();
        page.setPageNum(1);
        page.setPageSize(3000);
        List<OrgStudent> students = orgStudentDao.getByPage(page);
        while (students.size() > 0){
            for(OrgStudent orgStudent : students){
                bulkProcessor.add(
                    new IndexRequest()
                    .index(index)
                    .type(type)
                    .id(orgStudent.getId().toString())
                    .source(objectMapper.writeValueAsBytes(orgStudent))
                );
            }
            page.setPageNum(page.getPageNum() + 1);
            students = orgStudentDao.getByPage(page);
        }

        // fital! remember to flush
        bulkProcessor.flush();
        bulkProcessor.close();
        
        log.info("import {} data costs:{}", page.getCount(), System.currentTimeMillis() - time);
        
    }

}
