package com.baijia.tianxiao.dal.es.constant;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.dal.es.exceptions.EsException;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author weihongyan
 * @description TODO
 * @date 21/03/2017
 */
@Slf4j
public class EsClientConfig {

    public static final String addressString;
    public static final String clusterNameString;

    private EsClientConfig() {
    }

    static {
        String address = null;
        String clusterName = null;
        try {
            address = PropertiesReader.getValue("elasticsearch", "address");
            clusterName = PropertiesReader.getValue("elasticsearch", "clusterName");
            Preconditions.checkArgument(StringUtils.isNotEmpty(address), "address empty!");
            Preconditions.checkArgument(StringUtils.isNotEmpty(clusterName), "clusterName empty!");
            log.info("[EsClientConfig] read properties success! address:{}, clusterName:{}", address, clusterName);
        } catch (Exception e) {
            log.warn("[EsClientConfig] read properties failed! error:{}", e);
        } finally {
            addressString = address;
            clusterNameString = clusterName;
        }
    }

    public static List<Map.Entry<String, Integer>> getAddressList() {
        Preconditions.checkArgument(StringUtils.isNotEmpty(addressString) && StringUtils.isNotEmpty(clusterNameString),
            "properties read failed!");
        List<Map.Entry<String, Integer>> result = new ArrayList<>();
        try {
            String[] ipAndPorts = addressString.split(",");
            for (String ipAndPort : ipAndPorts) {
                String[] split = ipAndPort.split(":");
                result.add(new AbstractMap.SimpleEntry<String, Integer>(split[0], Integer.parseInt(split[1])));
            }
        } catch (RuntimeException e) {
            log.error("[EsClientConfig] read properties failed! maybe config style error:{}", e);
            throw new EsException(CommonErrorCode.SYSTEM_ERROR, "es配置文件读取错误");
        }
        return result;
    }
    
}
