
package com.baijia.tianxiao.dal.club.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.club.dao.OrgVipScanRecordDao;
import com.baijia.tianxiao.dal.club.po.OrgVipScanRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgVipScanRecordDaoImpl extends JdbcTemplateDaoSupport<OrgVipScanRecord> implements OrgVipScanRecordDao {

    public OrgVipScanRecordDaoImpl() {
        super(OrgVipScanRecord.class);
    }

    @Override
    public OrgVipScanRecord getLastOrgVipScanRecord(Integer type, Integer subType) {
        SingleSqlBuilder<OrgVipScanRecord> builder = createSqlBuilder();
        builder.eq("type", type);
        builder.eq("subType", subType);
        builder.desc("id");
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(1);
        pageDto.setPageSize(1);
        builder.setPage(pageDto);
        return uniqueResult(builder);
            
    }

    @Override
    public List<OrgVipScanRecord> getByTypes(Integer type, Integer subType, Integer index) {
        SingleSqlBuilder<OrgVipScanRecord> builder = createSqlBuilder();
        builder.gt("id", index);
        builder.eq("type", type);
        builder.eq("subType", subType);
        return queryList(builder);
    }

}

    